from uuid import uuid4

from scripts.constants.app_constants import DBConstants
from scripts.utils.mongo_util import MongoCollectionBaseClass


class ProfileCatalogCollection(MongoCollectionBaseClass):
    def __init__(self, mongo_client, project_id=None):
        super().__init__(
            mongo_client,
            database=DBConstants.db_ilens_yield_optimizer,
            collection=DBConstants.collection_yield_profile_catalog,
        )
        self.project_id = project_id

    def save_profile(self, data: dict):
        if data.get("id") is None:
            data["id"] = str(uuid4())
        self.update_one(
            query={"model_catalog_id": data.get("model_catalog_id")},
            data=data,
            upsert=True,
        )
        return {"id": data.get("id")}

    def partial_update_profile(self, profile_id, data: dict):
        # todo update meta also.
        self.update_one(query={"id": profile_id}, data=data)
        return id

    def get_one_profile_catalog(self, model_catalog_id):
        return self.find_one(query={"model_catalog_id": model_catalog_id})
