class KairosConstants:
    TRAINING_QUERY = {
        "metrics": [],
        "plugins": [],
        "cache_time": 0,
        "time_zone": "Asia/Calcutta",
        "start_absolute": None,
        "end_absolute": None,
    }
    LIVE_QUERY = {
        "metrics": [],
        "plugins": [],
        "cache_time": 0,
        "time_zone": "Asia/Calcutta",
        "start_relative": {"value": "30", "unit": "days"},
    }
    TAGS = {"tags": {"c3": []}, "name": None}
    GROUP_BY = {"group_by": [{"name": "tag", "tags": ["c3"]}]}
    # aggregators supported avg,count,first,gaps,last,least_squares,max,min,sum. total 9
    # aggregators not supported dev,diff,div,filter,percentile,rate,sampler,save_as
    # ,scale,trim total 10
    AGGREGATORS = {
        "aggregators": [{"name": None, "sampling": {"value": None, "unit": None}}]
    }
    AGGREGATOR_KEYS_MAPPING = {
        "AVG": "avg",
        "COUNT": "count",
        "FIRST": "first",
        "GAPS": "gaps",
        "LAST": "last",
        "LEAST SQUARES": "least_squares",
        "MAX": "max",
        "MIN": "min",
        "SUM": "sum",
    }
    ALIGNMENT_MAPPING = {
        "None": None,
        "Sample": "align_sampling",
        "Start Time": "align_start_time",
        "End Time": "align_end_time",
    }
    UNITS_MAPPING = {
        "Years": "years",
        "Months": "months",
        "Weeks": "weeks",
        "Days": "days",
        "Hours": "hours",
        "Minutes": "minutes",
        "Seconds": "seconds",
        "Milliseconds": "milliseconds",
    }
    TRAINING_INPUT_DICT = {
        "metric_name": "ilens.live_data.raw",
        "start_absolute": None,
        "end_absolute": None,
        "tag_details": [],
    }
    DEFAULT_TRAINING_INPUT_GROUP_BY = {
        "tag": None,
        "group_by": True,
        "aggregators": {
            "name": "AVG",
            "sampling_value": "15",
            "sampling_unit": "Minutes",
            "align": "End Time",
        },
    }


class Constants:
    FEATURE_IMPORTANCE_FILE_NAME = "feature_importance.csv"
    PROFILE_FILE_NAME = "profile.csv"
    TRAINING_FILE_NAME = "training.csv"


class DBConstants:
    # Databases
    db_ilens_yield_optimizer = "project_181__ilens_yield_optimizer"

    # Collections
    collection_yield_model_catalog = "yield_model_catalog"
    collection_yield_profile_catalog = "yield_profile_catalog"
