import traceback
from scripts.common.config_parser import config
from scripts.common.constants import ModelObjectConstants, ComponentExceptions
from scripts.common.logsetup import logger
from sklearn.ensemble import RandomForestRegressor
import pickle
import os


class ModelObject:
    def __init__(self, model_object, component_out_dir):
        self.model_object = model_object
        self.component_out_dir = component_out_dir

    def random_forest(self):
        try:
            logger.info("Creating Model object for the model " + self.model_object)
            rf = RandomForestRegressor()
            filename = 'random_forest.pkl'
            logger.info("Pickling the model.....")
            pickle.dump(rf, open(os.path.join(self.component_out_dir, filename), 'wb'))
            return True
        except Exception as e:
            logger.info(traceback.format_exc())
            raise FileNotFoundError(e)


if __name__ == '__main__':
    try:
        obj = ModelObject(config['model_name'], config['component_output_dir'])
        if config['model_name'] == ModelObjectConstants.RANDOMFOREST:
            val = obj.random_forest()
            if val:
                if len(os.listdir(config['component_output_dir'])) > 0:
                    logger.info("File Downloaded Successfully")
                else:
                    logger.info("The output directory is empty")
            else:
                logger.info("Model Object Download Component Failed")
                logger.info(traceback.format_exc())
    except Exception as e:
        logger.info("Model Object Download Component Failed")
        logger.info(traceback.format_exc())
