import os
import sys
from configparser import ConfigParser, BasicInterpolation

from dotenv import load_dotenv

# Configuration File Constants
_application_conf = f"./conf/application.conf"
_default_conf = f"./config.env"

load_dotenv(dotenv_path=_default_conf)


class EnvInterpolation(BasicInterpolation):
    """
    Interpolation which expands environment variables in values.
    """

    def before_get(self, parser, section, option, value, defaults):
        value = super().before_get(parser, section, option, value, defaults)

        if not os.path.expandvars(value).startswith("$"):
            return os.path.expandvars(value)
        else:
            return


try:
    config = ConfigParser(interpolation=EnvInterpolation())
    config.read(_application_conf)
except Exception as e:
    print(f"Error while loading the config: {e}")
    print("Failed to Load Configuration. Exiting!!!")
    sys.exit()


class Logging:
    level = config.get("LOGGING", "level", fallback="INFO")
    level = level if level else "INFO"
    tb_flag = config.getboolean("LOGGING", "traceback", fallback=True)
    tb_flag = tb_flag if tb_flag is not None else True


# Configuration Variables
class MlflowMetaData:
    MLFLOW_TRACKING_URI = config['MLFLOW']['mlflow_tracking_uri']
    MLFLOW_TRACKING_USERNAME = config['MLFLOW']['mlflow_tracking_username']
    MLFLOW_TRACKING_PASSWORD = config['MLFLOW']['mlflow_tracking_password']
    AZURE_STORAGE_CONNECTION_STRING = config['MLFLOW']['azure_storage_connection_string']
    AZURE_STORAGE_ACCESS_KEY = config['MLFLOW']['azure_storage_access_key']
    EXPERIMENT_NAME = config['MLFLOW']['experiment_name']
    RUN_NAME = config['MLFLOW']['run_name']
    MODEL_NAME = config['MLFLOW']['model_name']
    TOTAL_MODELS_NEEDED = config['MLFLOW']['total_models_needed']
