from loguru import logger
from scripts.constants.app_configuration import MlflowMetaData
from scripts.core.mlflow_util import MlflowCleanUp

if __name__ == '__main__':
    try:
        logger.info("Starting the Module...")
        experiment_name = MlflowMetaData.EXPERIMENT_NAME
        run_name = MlflowMetaData.RUN_NAME
        model_name = MlflowMetaData.MODEL_NAME
        logger.info(f"Performing cleanup for experiment: {experiment_name}, parent run: {run_name}, "
                    f"model name: {model_name}")
        _mcu_ = MlflowCleanUp(experiment_name, run_name, model_name)
        _mcu_.start_cleanup()
    except Exception as e:
        logger.exception(f"Error cleaning up because of error {e}")


