
def execute_sql_component():
    import io
    import warnings
    import os
    import psycopg2
    from azure.storage.blob import BlobServiceClient
    from loguru import logger

    warnings.filterwarnings('ignore')
    """
    Function to execute sql files
    """
    uri = os.getenv("uri")
    db_name = os.getenv("db_name")
    azure_file_path = os.getenv("azure_file_path")
    az_connection_string = os.getenv("az_connection_string")
    az_container_name = os.getenv("az_container_name")

    def execute_sql_file(conn, sql_file_data):
        """
        Execute a SQL script file using the provided PostgreSQL connection.

        Parameters:
            conn (psycopg2.extensions.connection): The PostgreSQL connection object.
            sql_file_data (str): The SQL script file data.

        Returns:
            None
        """
        with conn.cursor() as cur:
            cur.execute(sql_file_data)
            conn.commit()

    def get_azure_blob_data(connection_string, container_name, blob_path):
        logger.info(f"Getting azure blob data from {blob_path}")
        blob_service_client = BlobServiceClient.from_connection_string(connection_string)
        container_client = blob_service_client.get_container_client(container_name)
        blob_client = container_client.get_blob_client(blob_path)
        blob_data = blob_client.download_blob().readall()
        text_wrapper = io.TextIOWrapper(io.BytesIO(blob_data), encoding='utf-8')
        sql_query = text_wrapper.read()
        return sql_query

    postgres_uri = f"{uri}/{db_name}"
    logger.info("Started Executing the files...")
    logger.info(f"Files to execute are {azure_file_path}")
    try:
        connection = psycopg2.connect(postgres_uri)
        logger.info("Connection Successful")
        files_list = azure_file_path.split(',')
        for file in files_list:
            file_data = get_azure_blob_data(az_connection_string, az_container_name, file)
            logger.info(f"Executing script of file {file}")
            execute_sql_file(connection, file_data)
        # Close the connection
        connection.close()
    except Exception as e:
        logger.error(f"Failed because of error {e}")
