import kfp
from kfp import dsl
from loguru import logger


@dsl.pipeline(name="Test", description="Test Component")
def test_pipeline():
    """
    :return:
    """
    try:
        # Loading the component from the above yaml file
        execute_sql_file_component = kfp.components.load_component_from_file("postgres/execute_sql/component.yml")

        # Calling the component
        create_execute_sql_file_component_task = execute_sql_file_component()

        # Disabling cacheing for all the components
        create_execute_sql_file_component_task.execution_options.caching_strategy.max_cache_staleness = "P0D"


    except Exception as e:
        logger.exception(f"Unable to Perform the execution {e}")


if __name__ == "__main__":
    kfp.compiler.Compiler().compile(test_pipeline, "postgres-pipeline.yml")
