#!/usr/bin/env python

class RequestConstants:
    COMPONENT_NAME = "RequestModuleFE"
    Request_auth_username = "username"
    Request_auth_password = "password"
    Request_authentication = "authentication"
    Request_URL = "url"
    Request_method = "method"
    Request_headers = "headers"
    Request_payload = "payload"
    Shared_volume = "shared_volume"
    Method_get = "GET"
    Method_post = "POST"
    Request_max_retries = "max_retries"
    Default_retries = 1
    REQUEST_SUCCESS_CODE = 200
    ERRORS_KEY = "errors"
    Default_headers = {'content-type': 'application/json'}
    HTTP = "http://"
    LOG_VAR_MESSAGE = "\n" + "#" * 25 + "\n" + "{}" + "\n" + "#" * 25 + "\n" + "{}\n"


class ComponentExceptions:
    INVALID_REQUEST_URL_EXCEPTION = "Request url should be required"
    INVALID_REQUEST_METHOD_EXCEPTION = "Request Method should be required"
    INVALID_KAIROS_URL_EXCEPTION = "Kairos url should be required"
    INVALID_TAG_HIERARCHY_EXCEPTION = "Tag Hierarchy values should not be null"
    INVALID_METRIC_NAME_EXCEPTION = "metric_name key is not there"
    INVALID_START_TIME_FORMAT_EXCEPTION = "start time should be dd/mm/yyyy hh/MM/SS"
    INVALID_END_TIME_FORMAT_EXCEPTION = "end time should be dd/mm/yyyy hh/MM/SS"
    INVALID_START_TIME_VALUE_EXCEPTION = "start time should be greater than zero"
    MISSING_START_TIME_VALUE_EXCEPTION = "need start date for querying"
    MISSING_TAG_HIERARCHY_EXCEPTION = "required tag hierarchy"
    INVALID_START_END_VALUE_EXCEPTION = "end time should be greater than zero and less than start time"
    INVALID_HEADERS_EXCEPTION = "Need Headers for POST request"
