#!/usr/bin/env python
import os
import sys
import yaml
import json
from pymongo import MongoClient, DESCENDING
from scripts.common.constants import RequestConstants

config_path = os.path.join(os.getcwd(), "conf", "configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)

# ----------------- Mongo -----------------------------------------------------------------------

READ_FROM_MONGO = _config.get("FOR_EACH_MONGO_CONFIG", {}).get('READ_FROM_MONGO', False)
COMPONENT_NAME = os.environ.get("type", RequestConstants.COMPONENT_NAME)
pipeline_id = os.environ.get('PIPELINE_ID', default="pipeline_313")

if READ_FROM_MONGO:
    MONGO_URI = os.environ.get("MONGO_URI", _config.get("FOR_EACH_MONGO_CONFIG", {}).get('MONGO_URI'))
    MONGO_DB = os.environ.get("MONGO_DB", _config.get("FOR_EACH_MONGO_CONFIG", {}).get('MONGO_DB'))
    MONGO_RUN_COLL = _config.get("FOR_EACH_MONGO_CONFIG", {}).get('MONGO_RUN_COLL')
    MONGO_SITE_COLL = _config.get("FOR_EACH_MONGO_CONFIG", {}).get('MONGO_SITE_COLL')

    db = MongoClient(MONGO_URI)[MONGO_DB]
    get_run_info = db[MONGO_RUN_COLL].find_one({}, sort=[("run_start_time", DESCENDING)])

    if get_run_info is None:
        raise Exception('No run info found')

    if not get_run_info['job_metadata']['in_progress']:
        raise Exception('No job in progress')

    _tag_hierarchy = get_run_info['job_metadata']['in_progress'][0]
    sys.stdout.write(f"_tag_hierarchy --> {_tag_hierarchy}\n")
    _tag_hierarchy = _tag_hierarchy.split('$')
    site_id = _tag_hierarchy[0]
    dept_id = _tag_hierarchy[1]
    line_id = _tag_hierarchy[2]
    equipment_id = _tag_hierarchy[3]
    tag_id = _tag_hierarchy[4]

    get_conf = db[MONGO_SITE_COLL].find_one({'site_id': site_id})

    dept_dict = list(filter(lambda x: x['dept_id'] == dept_id, get_conf['dept']))
    line_dict = list(filter(lambda x: x['line_id'] == line_id, dept_dict[0]['line']))
    equipment_dict = list(filter(lambda x: x['equipment_id'] == equipment_id, line_dict[0]['equipment']))
    tag_dict = list(filter(lambda x: x['tag_id'] == tag_id, equipment_dict[0]['tag']))

    if len(tag_dict) != 1:
        raise Exception(f"Tag details not found for hierarchy {_tag_hierarchy}")
    pipeline_conf = list(filter(lambda x: x['pipeline_id'] == pipeline_id, tag_dict[0]['pipeline_config']))
    if len(pipeline_conf) != 1:
        raise Exception(
            f"Tag details not found for hierarchy {'$'.join(_tag_hierarchy)} not found for pipeline {pipeline_id}")
    component_conf = list(
        filter(lambda x: x['component_type'] == COMPONENT_NAME, pipeline_conf[0]['component_config']))

    if len(component_conf) == 0:
        raise Exception(f"Configuration for component {COMPONENT_NAME} not found")
    component_conf = component_conf[0]['env_variables']

    for each_key, each_value in component_conf.items():
        if not isinstance(each_value, str):
            component_conf[each_key] = json.dumps(each_value)

    os.environ.update(component_conf)

# ---------------- END MONGO -----------------------------------------------------------------
BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL", _config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "HttpRequestComponent")
ENABLE_LOGSTASH_LOG = os.environ.get("ENABLE_LOGSTASH_LOG", 'False').lower()
LOGSTASH_HOST = _config.get('SERVICE_CONFIG', {}).get('LOGSTASH_HOST')
LOGSTASH_PORT = str(_config.get('SERVICE_CONFIG', {}).get('LOGSTASH_PORT'))

# os.environ['shared_volume'] = 'test'
# os.environ['method'] = 'GET'
# os.environ['url'] = 'https://weather.visualcrossing.com/VisualCrossingWebServices/rest/services/timeline/aluva?unitGroup=metric&key=QMCRVJEPKK8YD7BP83BZTMZ7A'
# os.environ['headers'] = '{"content-type":"application/json"}'
# os.environ['payload'] = '{}'
# os.environ['max_retries'] = '1'
# os.environ['authentication'] = '{"username":"vamshi","password":"sai"}'
config = {
    "json_filename": os.environ.get("json_filename", default='response.json'),
    "shared_volume": os.environ.get("shared_volume"),
    "method": os.environ.get("method"),
    "url": os.environ.get("url"),
    "headers": json.loads(os.environ.get("headers")),
    "payload": json.loads(os.environ.get("payload", default='{}')),
    "max_retries": int(os.environ.get("max_retries")),
    "authentication": json.loads(os.environ.get("authentication", default='{}'))
}
if not os.path.exists(config['shared_volume']):
    sys.stderr.write("Shared path does not exist!")
    sys.stderr.write("Creating path --> {}".format(config['shared_volume']))
    os.makedirs(config['shared_volume'])
