import requests
from scripts.common.logsetup import logger
from scripts.common.constants import RequestConstants, ComponentExceptions
from scripts.common.config_parser import *
from requests.adapters import HTTPAdapter


class RequestComponent:
    def __init__(self):
        self.s = requests.Session()

    def execute_request(self, query):
        logger.info("Parsing user requests")

        # ---------------------- Validating URL ------------------------------------------------------------------------
        if RequestConstants.Request_URL in query.keys():
            request_url = query[RequestConstants.Request_URL]
        else:
            raise Exception(ComponentExceptions.INVALID_REQUEST_URL_EXCEPTION)

        # ---------------------- Validating Request Method -------------------------------------------------------------
        if RequestConstants.Request_method in query.keys():
            request_method = query[RequestConstants.Request_method]
        else:
            raise Exception(ComponentExceptions.INVALID_REQUEST_METHOD_EXCEPTION)

        # ---------------------- Validating Headers --------------------------------------------------------------------
        if RequestConstants.Request_headers in query.keys():
            request_headers = query[RequestConstants.Request_headers]
        else:
            request_headers = RequestConstants.Default_headers

        # ---------------------- Validating Headers --------------------------------------------------------------------
        if RequestConstants.Request_payload in query.keys():
            request_payload = query[RequestConstants.Request_payload]
        else:
            request_payload = {}

        # ---------------------- Validating Max retries ----------------------------------------------------------------
        if RequestConstants.Request_payload in query.keys() and query[RequestConstants.Request_max_retries] != 0:
            request_max_retries = query[RequestConstants.Request_max_retries]
            adapter = HTTPAdapter(max_retries=request_max_retries)
            self.s.mount(RequestConstants.HTTP, adapter)
        else:
            request_max_retries = RequestConstants.Default_retries
            adapter = HTTPAdapter(max_retries=request_max_retries)
            self.s.mount(RequestConstants.HTTP, adapter)

        # ---------------------- Sending Request -----------------------------------------------------------------------
        print(query)
        try:
            if query[RequestConstants.Request_method].upper() == RequestConstants.Method_get:
                # response = requests.request(RequestConstants.Method_get, url=request_url, headers=request_headers,
                #                             data=request_payload)
                response = self.s.get(url=request_url, headers=request_headers, data=json.dumps(request_payload))
                if response.status_code == RequestConstants.REQUEST_SUCCESS_CODE:
                    logger.info("Receiving data...")
                    return response.json()
                else:
                    raise Exception(response.json()[RequestConstants.ERRORS_KEY])
            elif query[RequestConstants.Request_method].upper() == RequestConstants.Method_post:
                if RequestConstants.Request_headers in query.keys() and len(request_headers) != 0:
                    request_headers = query[RequestConstants.Request_headers]
                else:
                    raise Exception(ComponentExceptions.INVALID_HEADERS_EXCEPTION)
                # response = requests.request(RequestConstants.Method_post, url=request_url, headers=request_headers,
                #                             data=json.dumps(request_payload))
                response = self.s.post(url=request_url, headers=request_headers, data=json.dumps(request_payload))
                if response.status_code == RequestConstants.REQUEST_SUCCESS_CODE:
                    logger.info("Receiving data...")
                    return response.json()
                else:
                    raise Exception(response.json()[RequestConstants.ERRORS_KEY])
        except Exception as e:
            raise Exception(e)


if __name__ == '__main__':
    obj = RequestComponent()
    data = obj.execute_request(config)
    logger.info("Writing data to response.json file")
    json_object = json.dumps(data, indent=4)
    with open(os.path.join(config['shared_volume'], 'response.json'), "w") as outfile:
        outfile.write(json_object)
