#!/usr/bin/env python
import os
import sys
import yaml
import json

config_path = os.path.join(os.getcwd(), "conf", "configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)

BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL", _config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "HttpRequestComponent")
os.environ['shared_volume'] = 'test'
os.environ['method'] = 'POST'
os.environ['url'] = 'http://localhost:5000/get'
os.environ['headers'] = '{"content-type":"application/json"}'
os.environ['payload'] = '{"name": "vamshi", "gender": "male"}'
os.environ['max_retries'] = '1'
os.environ['authentication'] = '{"username":"vamshi","password":"sai"}'
config = {
    "shared_volume": os.environ.get("shared_volume"),
    "method": os.environ.get("method"),
    "url": os.environ.get("url"),
    "headers": json.loads(os.environ.get("headers")),
    "payload": json.loads(os.environ.get("payload")),
    "max_retries": int(os.environ.get("max_retries")),
    "authentication": json.loads(os.environ.get("authentication"))
}
if not os.path.exists(config['shared_volume']):
    sys.stderr.write("Shared path does not exist!")
    sys.stderr.write("Creating path --> {}".format(config['shared_volume']))
    os.makedirs(config['shared_volume'])
