#!/usr/bin/env python
import os
import sys
import yaml
import json
from pymongo import MongoClient, DESCENDING
from scripts.common.constants import GetDataFromStoreConstants

config_path = os.path.join(os.getcwd(), "conf", "configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)

# os.environ['pipeline_id'] = "pipe1"
# os.environ['artifact_base_path'] = "/data/model/tested/"

# ------------------------ Configurations -----------------------------------------------------------------------------
pipeline_id = os.environ.get('PIPELINE_ID', default="pipeline_313")
shared_mount_base_ai_job = os.environ.get("shared_mount_base_ai_job",
                                          _config.get("SYSTEM_CONFIG", {}).get('shared_mount_base_ai_job'))
# read from $shared_mount_base_ai_job/$pipeline_id/run.config
# run_id_path = shared_mount_base_ai_job + "/" + pipeline_id + "/run_config.json"
run_id_path = os.path.join(shared_mount_base_ai_job, pipeline_id, "run_config.json")
try:
    sys.stderr.write("Checking for run id parameters at path " + run_id_path + "\n")
    with open(run_id_path) as f:
        run_id_param = json.load(f)
except Exception as e:
    raise Exception(e)
run_id = run_id_param['run_id']
data_store = os.environ.get('data_store', default="Azure")
container_name = os.environ.get('container_name', default=GetDataFromStoreConstants.CONTAINER)
connection_string = os.environ.get('connection_string', _config.get("SYSTEM_CONFIG", {}).get('connection_string'))
artifact_base_path = os.environ.get('artifact_base_path')
# Component Parameter:Read from $shared_mount_base_ai_job/$pipeline_id/$run_id/GetDataFromStore/param.json
# component_parameter_path = shared_mount_base_ai_job + "/" + pipeline_id + "/" + run_id + "/" + GetDataFromStoreConstants.COMPONENT_NAME + "/param.json"
component_parameter_path = os.path.join(shared_mount_base_ai_job, pipeline_id, run_id,
                                        GetDataFromStoreConstants.COMPONENT_NAME, "param.json")

try:
    sys.stderr.write("Checking for component parameters at path " + component_parameter_path + "\n")
    with open(component_parameter_path) as f:
        component_parameter = json.load(f)
except Exception as e:
    raise Exception(e)
artifact_name = component_parameter['artifact_name']
# $shared_mount_base_ai_job/$pipeline_id/$run_id/PreprocessWeatherData/input/$artifact_Name
# component_output_dir = shared_mount_base_ai_job + "/" + pipeline_id + "/" + run_id + "/" + GetDataFromStoreConstants.NEXT_COMPONENT + "/input"
component_output_dir = os.path.join(shared_mount_base_ai_job, pipeline_id, run_id,
                                    GetDataFromStoreConstants.NEXT_COMPONENT, "input")
BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL", _config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "GetDataFromStore")
ENABLE_LOGSTASH_LOG = os.environ.get("ENABLE_LOGSTASH_LOG", 'False').lower()
LOGSTASH_HOST = _config.get('SERVICE_CONFIG', {}).get('LOGSTASH_HOST')
LOGSTASH_PORT = str(_config.get('SERVICE_CONFIG', {}).get('LOGSTASH_PORT'))

# os.environ['azure_file_path'] = '/data/model/tested/test1.pkl'
# os.environ['local_file_path'] = r'E:\iLens-AI\azure-file-download\StandardScaler.pkl'

config = {
    'pipeline_id': pipeline_id,
    'run_id': run_id,
    'shared_mount_base_ai_job': shared_mount_base_ai_job,
    'data_store': data_store,
    'container_name': container_name,
    'artifact_base_path': artifact_base_path,
    'artifact_name': artifact_name,
    'connection_string': connection_string,
    'component_output_dir': component_output_dir,
    # 'run_id_path': run_id_path,
    # 'component_parameter_path': component_parameter_path
}

if not os.path.exists(config['shared_mount_base_ai_job']):
    sys.stderr.write("Shared path does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['shared_mount_base_ai_job'] + "\n"))
    os.makedirs(config['shared_mount_base_ai_job'])

if not os.path.exists(config['component_output_dir']):
    sys.stderr.write("component_output_dir does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['component_output_dir'] + "\n"))
    os.makedirs(config['component_output_dir'])
