########### Python 3.6 #############

#
# This quickstart shows how to add utterances to a LUIS model using the REST APIs.
#

import requests

try:

    ##########
    # Values to modify.

    # YOUR-APP-ID: The App ID GUID found on the www.luis.ai Application Settings page.
    appId = "45646243-2016-4f0a-9145-e93a7f58e355"

    # YOUR-AUTHORING-KEY: Your LUIS authoring key, 32 character value.
    authoring_key = "f19be164fbfc49a3972f940835820d7e"

    # YOUR-AUTHORING-ENDPOINT: Replace this with your authoring key endpoint.
    # For example, "https://your-resource-name.cognitiveservices.azure.com/"
    authoring_endpoint = "https://westus.api.cognitive.microsoft.com"

    # The version number of your LUIS app
    app_version = "0.1"
    ##########

    # The headers to use in this REST call.
    headers = {'Ocp-Apim-Subscription-Key': authoring_key}

    # The URL parameters to use in this REST call.
    params ={
        #'timezoneOffset': '0',
        #'verbose': 'true',
        #'show-all-intents': 'true',
        #'spellCheck': 'false',
        #'staging': 'false'
    }

    # List of example utterances to send to the LUIS app.
    data = """[
    {
        'text': 'give me the list of my task details',
        'intentName': 'task'
    }
]
"""


    # Make the REST call to POST the list of example utterances.
    response = requests.post(f'{authoring_endpoint}luis/authoring/v3.0-preview/apps/{appId}/versions/{app_version}/examples',
        headers=headers, params=params, data=data)

    # Display the results on the console.
    print('Add the list of utterances:')
    print(response.json())


    # Make the REST call to initiate a training session.
    response = requests.post(f'{authoring_endpoint}luis/authoring/v3.0-preview/apps/{appId}/versions/{app_version}/train',
        headers=headers, params=params, data=None)

    # Display the results on the console.
    print('Request training:')
    print(response.json())


    # Make the REST call to request the status of training.
    response = requests.get(f'{authoring_endpoint}luis/authoring/v3.0-preview/apps/{appId}/versions/{app_version}/train',
        headers=headers, params=params, data=None)

    # Display the results on the console.
    print('Request training status:')
    print(response.json())


except Exception as e:
    # Display the error string.
    print(f'{e}')