# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License.
from typing import List

from datatypes_date_time.timex import Timex

from botbuilder.dialogs import WaterfallDialog, WaterfallStepContext, DialogTurnResult
from botbuilder.dialogs.prompts import ConfirmPrompt, TextPrompt, PromptOptions
from botbuilder.core import MessageFactory
from botbuilder.schema import InputHints
from .cancel_and_help_dialog import CancelAndHelpDialog
import os
import json
from botbuilder.schema import Attachment, ChannelAccount
from botbuilder.schema import ChannelAccount, CardAction, ActionTypes, SuggestedActions
from botbuilder.dialogs.prompts import ConfirmPrompt, ChoicePrompt, PromptOptions
from botbuilder.dialogs.choices import Choice


class safetychecklist(CancelAndHelpDialog):
    def __init__(self, dialog_id: str = None):
        super(safetychecklist, self).__init__(dialog_id or safetychecklist.__name__)

        self.add_dialog(TextPrompt(TextPrompt.__name__))
        self.add_dialog(ConfirmPrompt(ConfirmPrompt.__name__))
        self.add_dialog(ChoicePrompt(ChoicePrompt.__name__))
        self.yes_no = [
            "Yes",
            "No"
        ]
        self.DONE_OPTION = "done"
        # self.add_dialog(
        #     WaterfallDialog(
        #         WaterfallDialog.__name__,
        #         [
        #             self.final_step, self.second_step, self.third_step, self.fourth_step, self.fifth_step, self.end_step
        #         ],
        #     )
        # )
        self.add_dialog(
            WaterfallDialog(
                WaterfallDialog.__name__,
                [
                    self.create_method("first"),self.create_method("second")
                ],
            )
        )

        self.initial_dialog_id = WaterfallDialog.__name__

    def create_method(self, type_):
        if type_ == 'first':
            async def foo(step_context: WaterfallStepContext) -> DialogTurnResult:
                message_text = "hi"
                prompt_message = MessageFactory.text(
                    message_text, message_text, InputHints.expecting_input
                )
                return await step_context.prompt(
                    TextPrompt.__name__, PromptOptions(prompt=prompt_message)
                )
        else:
            async def foo(step_context: WaterfallStepContext) -> DialogTurnResult:
                message_text = step_context.result
                prompt_message = MessageFactory.text(
                    message_text, message_text, InputHints.expecting_input
                )
                return await step_context.prompt(
                    TextPrompt.__name__, PromptOptions(prompt=prompt_message)
                )
        return foo
    # async def final_step(self, step_context: WaterfallStepContext) -> DialogTurnResult:
    #     """
    #     Complete the interaction and end the dialog.
    #     :param step_context:
    #     :return DialogTurnResult:
    #     """
    #     task_card = self.create_adaptive_card_attachment()
    #     response = MessageFactory.attachment(task_card)
    #     await step_context.context.send_activity(response)
    #     await step_context.context.send_activity("Now starting STEP 1 of 2     Safety checklist")
    #     options = self.yes_no.copy()
    #     # return await step_context.prompt(ChoicePrompt.__name__)
    #     prompt_options = PromptOptions(
    #         prompt=MessageFactory.text("Are you wearing safety helmet?"),
    #         retry_prompt=MessageFactory.text("Please choose an option from the list."),
    #         choices=self._to_choices(options),
    #     )
    #     return await step_context.prompt(ChoicePrompt.__name__, prompt_options)
    #     # reply = MessageFactory.text("Are you wearing safety helmet?")
    #     #
    #     # reply.suggested_actions = SuggestedActions(
    #     #     actions=[
    #     #         CardAction(
    #     #             title="Yes",
    #     #             type=ActionTypes.im_back,
    #     #             value='yes'
    #     #         ),
    #     #         CardAction(
    #     #             title="No",
    #     #             type=ActionTypes.im_back,
    #     #             value='no'
    #     #         )
    #     #     ]
    #     # )
    #     # return await step_context.prompt(
    #     #     TextPrompt.__name__, PromptOptions(prompt=reply)
    #     # )
    #
    # async def second_step(self, step_context: WaterfallStepContext) -> DialogTurnResult:
    #     """
    #     Complete the interaction and end the dialog.
    #     :param step_context:
    #     :return DialogTurnResult:
    #     """
    #     print(step_context.result)
    #     reply = MessageFactory.text("Are you wearing safety goggles?")
    #     reply.suggested_actions = SuggestedActions(
    #         actions=[
    #             CardAction(
    #                 title="Yes",
    #                 type=ActionTypes.im_back,
    #                 value='yes'
    #             ),
    #             CardAction(
    #                 title="No",
    #                 type=ActionTypes.im_back,
    #                 value='no'
    #             )
    #         ]
    #     )
    #     return await step_context.prompt(
    #         TextPrompt.__name__, PromptOptions(prompt=reply)
    #     )
    #
    # async def third_step(self, step_context: WaterfallStepContext) -> DialogTurnResult:
    #     """
    #     Complete the interaction and end the dialog.
    #     :param step_context:
    #     :return DialogTurnResult:
    #     """
    #     await step_context.context.send_activity("Now starting STEP 2 of 2     Visual Inspection")
    #     reply = MessageFactory.text("Observations*")
    #
    #     reply.suggested_actions = SuggestedActions(
    #         actions=[
    #             CardAction(
    #                 title="Dicoloration",
    #                 type=ActionTypes.im_back,
    #                 value='Dicoloration'
    #             ),
    #             CardAction(
    #                 title="change in sound",
    #                 type=ActionTypes.im_back,
    #                 value='change in sound'
    #             ),
    #             CardAction(
    #                 title="Visible leak",
    #                 type=ActionTypes.im_back,
    #                 value='Visible leak'
    #             )
    #         ]
    #     )
    #     return await step_context.prompt(
    #         TextPrompt.__name__, PromptOptions(prompt=reply)
    #     )
    #
    # async def fourth_step(self, step_context: WaterfallStepContext) -> DialogTurnResult:
    #     """
    #     Complete the interaction and end the dialog.
    #     :param step_context:
    #     :return DialogTurnResult:
    #     """
    #     reply = MessageFactory.text("Bushing Conditions*")
    #
    #     reply.suggested_actions = SuggestedActions(
    #         actions=[
    #             CardAction(
    #                 title="Good",
    #                 type=ActionTypes.im_back,
    #                 value='good'
    #             ),
    #             CardAction(
    #                 title="Fair",
    #                 type=ActionTypes.im_back,
    #                 value='fair'
    #             ),
    #             CardAction(
    #                 title="Poor",
    #                 type=ActionTypes.im_back,
    #                 value='poor'
    #             )
    #         ]
    #     )
    #     return await step_context.prompt(
    #         TextPrompt.__name__, PromptOptions(prompt=reply)
    #     )
    #
    # async def fifth_step(self, step_context: WaterfallStepContext) -> DialogTurnResult:
    #     """
    #     Complete the interaction and end the dialog.
    #     :param step_context:
    #     :return DialogTurnResult:
    #     """
    #     reply = MessageFactory.text("Mechanical Seal for Leakage *")
    #
    #     reply.suggested_actions = SuggestedActions(
    #         actions=[
    #             CardAction(
    #                 title="Safe",
    #                 type=ActionTypes.im_back,
    #                 value='safe'
    #             ),
    #             CardAction(
    #                 title="At risk",
    #                 type=ActionTypes.im_back,
    #                 value='risk'
    #             ),
    #             CardAction(
    #                 title="Not applicable",
    #                 type=ActionTypes.im_back,
    #                 value='not applicable'
    #             )
    #         ]
    #     )
    #     return await step_context.prompt(
    #         TextPrompt.__name__, PromptOptions(prompt=reply)
    #     )
    #
    # async def end_step(self, step_context: WaterfallStepContext) -> DialogTurnResult:
    #     await step_context.context.send_activity("Thank you for completing your tasks")
    #     return await step_context.end_dialog()
    #
    # def is_ambiguous(self, timex: str) -> bool:
    #     timex_property = Timex(timex)
    #     return "definite" not in timex_property.types
    #
    # def create_adaptive_card_attachment(self):
    #     relative_path = os.path.abspath(os.path.dirname(__file__))
    #     path = os.path.join(relative_path, "../cards/task.json")
    #     with open(path) as in_file:
    #         card = json.load(in_file)
    #
    #     return Attachment(
    #         content_type="application/vnd.microsoft.card.adaptive", content=card
    #     )
    #
    # def _to_choices(self, choices: [str]) -> List[Choice]:
    #     choice_list: List[Choice] = []
    #     for choice in choices:
    #         choice_list.append(Choice(value=choice))
    #     return choice_list
