class RawConstants:
    columns = ['Time Stamp',
               'Shipper size No.',
               'Shipper No.1 DH',
               'Shipper No.1 Pallet',
               'Shipper No.3 DH',
               'Shipper No.2 Pallet',
               'Shipper No.3 DH.1',
               'Shipper No.3 Pallet',
               'Size No (INDEX No)',
               'Weighing times',
               'Process mass',
               'Mass',
               'Material detection',
               'Surface temperature (mixer side)',
               'Surface temperature (center)',
               'Surface temperature (receiving side)',
               'temperature',
               'humidity',
               'Weighing command No.',
               'spare',
               'spare.1',
               'spare.2',
               'spare.3',
               'spare.4',
               'Size No (INDEX No).1',
               'Weighing times.1',
               'Process mass.1',
               'real mass',
               'spare.5',
               'spare.6',
               'spare.7',
               'Size No (INDEX No).2',
               'Weighing times.2',
               'Process mass.2',
               'CB weighing machine measurement',
               'Dust collection duct (Immediately after ****)',
               'Dust collection duct (before dust collector)\n',
               'CB slot open',
               'CB slot closed',
               'carbon cycle',
               'carbon2 cycle',
               'spare.8',
               'spare.9',
               'spare.10',
               'spare.11',
               'Size No (INDEX No).3',
               'Size name',
               'Mixing batch number',
               'Mixing Weight (Integrated Value)',
               'Rotor actual rpm',
               'Mixing timer value',
               'Temperature (DS side)',
               'Temperature (WS side)',
               'Electric power',
               'Electric energy',
               'Mixing electric power average',
               'Ram pressure',
               'Ram rising',
               'Ram down',
               'Ram position',
               'front door open',
               'Front door closed',
               'lower door open',
               'lower door closed',
               'Before mixer rotation detection',
               'After mixer rotation detection',
               'Drilled side left Inlet side Cooling water temperature',
               'Drilled side left Exit side Cooling water temperature',
               'Drilled side right Inlet side Cooling water temperature',
               'Drilled side right Exit side Cooling water temperature',
               'Mixer rotor left inlet side Coolant temperature',
               'Mixer rotor left output side Cooling water temperature',
               'Mixer rotor right inlet side Coolant temperature',
               'Mixer rotor right exit side Cooling water temperature',
               'Mixer body temperature',
               'Drilled side left Inlet side Cooling water flow rate',
               'Drilled side left Exit side Cooling water flow rate',
               'Drilled side right Inlet side Cooling water flow rate',
               'Drilled side right Exit side Cooling water flow rate',
               'Mixer rotor left inlet side Cooling water flow rate',
               'Mixer rotor left outlet side Cooling water flow rate',
               'Mixer rotor right inlet side Cooling water flow rate',
               'Mixer rotor right outlet side Cooling water flow rate',
               'temperature.1',
               'humidity.1',
               'idle time between batches',
               'spare.12',
               'spare.13',
               'spare.14',
               'spare.15',
               'spare.16',
               'spare.17',
               'spare.18',
               'Size No (INDEX No).4',
               'discharge length',
               'Hopper bank upper limit',
               'middle of hopper bank',
               'Hopper bank lower limit',
               'Hopper bank below lower limit',
               'Extruder rpm',
               'Extruder current',
               'Calendar rpm',
               ' Calendar current',
               'Calendar bank load',
               'Calendar GAP Operation side',
               'Calendar GAP Opposite operation side',
               'Residence time',
               'Screw operation side Inlet side Cooling water temperature',
               'Screw operation side Outlet side Cooling water temperature',
               'Screw Opposite operation side Inlet side Cooling water temperature',
               'Screw Opposite operation side Outlet side Cooling water temperature',
               'Calender roll Lower side Inlet side Cooling water temperature',
               'Calender roll  Lower side  Outlet  side Cooling water temperature',
               'Calender roll upper side Inlet side Cooling water temperature',
               'Calender roll Upper side  Outlet  side Cooling water temperature',
               'Screw operation side Inlet side Cooling water flow rate',
               'Screw operation side Outlet side Cooling water flow rate',
               'Screw Opposite operation side Inlet side Cooling water flow rate',
               'Screw Opposite operation side Outlet side Cooling water flow rate',
               'Calender roll Lower side Inlet side Cooling water flow rate',
               'Calender roll  Lower side  Outlet  side Cooling water flow rate',
               'Calender roll upper side Inlet side Cooling water flow rate',
               'Calender roll Upper side  Outlet  side Cooling water flow rate',
               'Extruder body temperature',
               'spare.19',
               'spare.20',
               'spare.21',
               'spare.22',
               'spare.23',
               'spare.24',
               'spare.25',
               'Size No (INDEX No).5',
               'length passed through',
               'Material detection.1',
               'Sheet temperature immediately after calendering',
               'Withdrawal CV speed',
               'DUST CV\nspeed',
               'spare.26',
               'spare.27',
               'spare.28',
               'Size No (INDEX No).6',
               'length passed through.1',
               'Material detection.2',
               'Seat temperature immediately after BOF',
               'temperature.2',
               'humidity.2',
               'spare.29',
               'spare.30',
               'spare.31',
               'spare.32',
               'Size No (INDEX No).7',
               'Setting length',
               'length passed through(Integrated Value)',
               'Mass\n(Integrated Value)',
               'Pallet No.',
               'Loading completion flag',
               'spare.33',
               'spare.34',
               'spare.35',
               'spare.36',
               'mixer cooling water',
               'Under cooling water']


class ViscosityConstants:
    rubber_cols = [
        'Quantity using type1 bale',
        'PO_type1',
        'DIRT_type1',
        'ASH_type1',
        'VM_type1',
        'PRI_type1',
        'NITROGEN_type1',
        'Temperature during transportation_type1[℃]',
        'Humidity during transportation_type1[%]',
        'Quantity using type2 bale',
        'PO_type2',
        'DIRT_type1.1',
        'ASH_type2',
        'VM_type2',
        'PRI_type2',
        'NITROGEN_type2',
        'Temperature during transportation_type2[℃]',
        'Humidity during transportation__type2[%]'
    ]
    req_cols = [
        'Rubber No.', 'Batch No.', 'Index No',
        'Input rubber weight(0.1kg)', 'date', 'batch-date',
        'Weight_type1', 'Weight_type2', 'Weighted_PO_type',
        'Weighted_DIRT_type', 'Weighted_ASH_type', 'Weighted_VM_type',
        'Weighted_PRI_type', 'Weighted_NITROGEN_type',
        'Weighted_Temperature during transportation_type[℃]',
        'Weighted_Humidity during transportation__type[%]', 'Weighted Sum', 'viscosity']


class SheetConstants:
    sheet_supply_column = ['Time Stamp',
                           'Shipper size No.',
                           'Shipper No.1 DH',
                           'Shipper No.1 Pallet',
                           'Shipper No.3 DH',
                           'Shipper No.2 Pallet',
                           'Shipper No.3 DH.1',
                           'Shipper No.3 Pallet',
                           'Size No (INDEX No)',
                           'Weighing times',
                           'Process mass',
                           'Mass',
                           'Material detection',
                           'Surface temperature (mixer side)',
                           'Surface temperature (center)',
                           'Surface temperature (receiving side)',
                           'temperature',
                           'humidity',
                           'Weighing command No.',
                           'spare',
                           'spare.1',
                           'spare.2',
                           'spare.3',
                           'spare.4']
    aggregation_dict = {
        "Surface temperature (mixer side)": "mean",
        "Surface temperature (center)": "std",
        "Surface temperature (receiving side)": "mean",
        "temperature": "mean",
        "humidity": "mean",
        'Process mass': 'mean',
    }


class MixerConstants:
    mixer_cols = ['Time Stamp',
                  'Size No (INDEX No).3',
                  'Size name',
                  'Mixing batch number',
                  'Mixing Weight (Integrated Value)',
                  'Rotor actual rpm',
                  'Mixing timer value',
                  'Temperature (DS side)',
                  'Temperature (WS side)',
                  'Electric power',
                  'Electric energy',
                  'Mixing electric power average',
                  'Ram pressure',
                  'Ram rising',
                  'Ram down',
                  'Ram position',
                  'front door open',
                  'Front door closed',
                  'lower door open',
                  'lower door closed',
                  'Before mixer rotation detection',
                  'After mixer rotation detection',
                  'Drilled side left Inlet side Cooling water temperature',
                  'Drilled side left Exit side Cooling water temperature',
                  'Drilled side right Inlet side Cooling water temperature',
                  'Drilled side right Exit side Cooling water temperature',
                  'Mixer rotor left inlet side Coolant temperature',
                  'Mixer rotor left output side Cooling water temperature',
                  'Mixer rotor right inlet side Coolant temperature',
                  'Mixer rotor right exit side Cooling water temperature',
                  'Mixer body temperature',
                  'Drilled side left Inlet side Cooling water flow rate',
                  'Drilled side left Exit side Cooling water flow rate',
                  'Drilled side right Inlet side Cooling water flow rate',
                  'Drilled side right Exit side Cooling water flow rate',
                  'Mixer rotor left inlet side Cooling water flow rate',
                  'Mixer rotor left outlet side Cooling water flow rate',
                  'Mixer rotor right inlet side Cooling water flow rate',
                  'Mixer rotor right outlet side Cooling water flow rate',
                  'temperature.1',
                  'humidity.1',
                  'idle time between batches',
                  ]
    aggregation_dict = {
        'Mixing timer value': 'max',
        'Temperature (DS side)': 'mean',
        'Temperature (WS side)': 'std',
        'Electric power': 'mean',
        'Electric energy': 'mean',
        'Mixing electric power average': 'mean',
        'Ram pressure': 'mean',
        #  'Ram rising': '',
        #  'Ram down': '',
        'Ram position': 'std',
        #  'front door open': '',
        #  'Front door closed': '',
        #  'lower door open': '',
        #  'lower door closed': '',
        #  'Before mixer rotation detection': '',
        #  'After mixer rotation detection': '',
        'Drilled side left Inlet side Cooling water temperature': 'std',
        'Drilled side left Exit side Cooling water temperature': 'mean',  #
        'Drilled side right Inlet side Cooling water temperature': 'mean',
        'Drilled side right Exit side Cooling water temperature': 'std',
        'Mixer rotor left inlet side Coolant temperature': 'std',
        'Mixer rotor left output side Cooling water temperature': 'mean',
        'Mixer rotor right inlet side Coolant temperature': 'mean',
        'Mixer rotor right exit side Cooling water temperature': 'std',
        'Mixer body temperature': 'mean',
        'Drilled side left Inlet side Cooling water flow rate': 'std',
        'Drilled side left Exit side Cooling water flow rate': 'mean',  #
        'Drilled side right Inlet side Cooling water flow rate': 'mean',
        'Drilled side right Exit side Cooling water flow rate': 'std',  #
        'Mixer rotor left inlet side Cooling water flow rate': 'std',
        'Mixer rotor left outlet side Cooling water flow rate': 'mean',
        'Mixer rotor right inlet side Cooling water flow rate': 'mean',
        'Mixer rotor right outlet side Cooling water flow rate': 'std',
        'temperature.1': 'mean',
        'humidity.1': 'mean',
        'idle time between batches': 'mean',
        'Mixing Weight (Integrated Value)_diff': 'max',  # any agg will work
        'max_rpm_count': 'max'  # any agg will work
    }


class ExtruderConstants:
    extruder_cols = ['Size No (INDEX No).4',
                     'discharge length',
                     'Hopper bank upper limit',
                     'middle of hopper bank',
                     'Hopper bank lower limit',
                     'Hopper bank below lower limit',
                     'Extruder rpm',
                     'Extruder current',
                     'Calendar rpm',
                     ' Calendar current',
                     'Calendar bank load',
                     'Calendar GAP Operation side',
                     'Calendar GAP Opposite operation side',
                     'Residence time',
                     'Screw operation side Inlet side Cooling water temperature',
                     'Screw operation side Outlet side Cooling water temperature',
                     'Screw Opposite operation side Inlet side Cooling water temperature',
                     'Screw Opposite operation side Outlet side Cooling water temperature',
                     'Calender roll Lower side Inlet side Cooling water temperature',
                     'Calender roll  Lower side  Outlet  side Cooling water temperature',
                     'Calender roll upper side Inlet side Cooling water temperature',
                     'Calender roll Upper side  Outlet  side Cooling water temperature',
                     'Screw operation side Inlet side Cooling water flow rate',
                     'Screw operation side Outlet side Cooling water flow rate',
                     'Screw Opposite operation side Inlet side Cooling water flow rate',
                     'Screw Opposite operation side Outlet side Cooling water flow rate',
                     'Calender roll Lower side Inlet side Cooling water flow rate',
                     'Calender roll  Lower side  Outlet  side Cooling water flow rate',
                     'Calender roll upper side Inlet side Cooling water flow rate',
                     'Calender roll Upper side  Outlet  side Cooling water flow rate',
                     'Extruder body temperature',
                     'spare.19',
                     'spare.20',
                     'spare.21',
                     'spare.22',
                     'spare.23',
                     'spare.24',
                     'spare.25']
    aggregate_dict = {
        'discharge length': "max",
        'Extruder rpm': "mean",
        'Extruder current': "std",
        'Calendar rpm': "std",
        ' Calendar current': "mean",
        'Calendar bank load': "max",
        'Calendar GAP Operation side': "median",
        'Calendar GAP Opposite operation side': "std",
        'Residence time': "max",
        'Screw operation side Inlet side Cooling water temperature': "mean",
        'Screw operation side Outlet side Cooling water temperature': "std",
        'Screw Opposite operation side Inlet side Cooling water temperature': "mean",
        'Screw Opposite operation side Outlet side Cooling water temperature': "std",
        'Calender roll Lower side Inlet side Cooling water temperature': "mean",
        'Calender roll  Lower side  Outlet  side Cooling water temperature': "std",
        'Calender roll upper side Inlet side Cooling water temperature': "mean",
        'Calender roll Upper side  Outlet  side Cooling water temperature': "std",
        'Screw operation side Inlet side Cooling water flow rate': "mean",
        'Screw operation side Outlet side Cooling water flow rate': "std",
        'Screw Opposite operation side Inlet side Cooling water flow rate': "mean",
        'Screw Opposite operation side Outlet side Cooling water flow rate': "std",
        'Calender roll Lower side Inlet side Cooling water flow rate': "mean",
        'Calender roll  Lower side  Outlet  side Cooling water flow rate': "std",
        'Calender roll upper side Inlet side Cooling water flow rate': "mean",
        'Calender roll Upper side  Outlet  side Cooling water flow rate': "std",
        'Extruder body temperature': "mean"
    }


class PickupConstants:
    pick_cols = ['Size No (INDEX No).6',
                 'length passed through.1',
                 'Material detection.2',
                 'Seat temperature immediately after BOF',
                 'temperature.2',
                 'humidity.2',
                 'spare.29',
                 'spare.30',
                 'spare.31',
                 'spare.32']

    pick_imp_mixer_cols = ['Time Stamp',
                           'Size No (INDEX No).3',
                           'Size name',
                           'Mixing batch number',
                           'idle time between batches',
                           ]

    pick_imp_bof_cols = ['Time Stamp',
                         'Size No (INDEX No).5',
                         'bof_batch_number'
                         ]

    pick_additional_cols = ['day',
                            'Time Stamp',
                            'length passed through',
                            'discharge length']

    pick_aggregate_dict = {'Seat temperature immediately after BOF': 'mean', 'viscosity': 'mean'}

    pick_grouped_cols = ['batch-date']


class BofConstants:
    bof_cols = ['Size No (INDEX No).5',
                'length passed through',
                'Material detection.1',
                'Sheet temperature immediately after calendering',
                'Withdrawal CV speed',
                'DUST CV\nspeed', 'spare.26',
                'spare.27',
                'spare.28', 'lower door open']

    bof_add_cols = ['Time Stamp', 'day', 'lower door open']

    bof_mixer_cols = ['Time Stamp',
                      'Size No (INDEX No).3',
                      'Size name',
                      'Mixing batch number',
                      'idle time between batches']

    bof_aggregate_dict = aggregate_dict = {'Sheet temperature immediately after calendering': 'mean',
                                           'Withdrawal CV speed': 'mean',
                                           'DUST CV\nspeed': 'std'}