import warnings

import pandas as pd

from scripts.constants.constants import SheetConstants

warnings.filterwarnings("ignore")


def preprocess_sheet_section(df, index_number):
    sheet_supply_column = SheetConstants.sheet_supply_column
    sheet_supply_df = df[sheet_supply_column]
    sheet_supply_df['Time Stamp'] = pd.to_datetime(sheet_supply_df['Time Stamp'])
    sheet_supply_df = sheet_supply_df.sort_values(by='Time Stamp')
    numeric_cols = sheet_supply_df.select_dtypes(include=['int', 'float']).columns
    # Convert numeric columns to float
    sheet_supply_df[numeric_cols] = sheet_supply_df[numeric_cols].astype(float)
    sheet_supply_df['day'] = sheet_supply_df['Time Stamp'].dt.date
    sheet_supply_df['batch-date'] = 'Batch_' + sheet_supply_df['Weighing times'].astype(str) + '_' + sheet_supply_df[
        'day'].astype(str)
    sheet_supply_df = sheet_supply_df[sheet_supply_df["Size No (INDEX No)"] == index_number]
    sheet_supply_df = sheet_supply_df[sheet_supply_df["Weighing times"] != 0]
    aggregation_dict = SheetConstants.aggregation_dict
    group_by = ['day', 'Weighing times']
    df_sheet_grouped = sheet_supply_df.groupby(group_by).agg(aggregation_dict).reset_index()
    col_renamer = {}
    for col, col_agg in aggregation_dict.items():
        if col not in ['viscosity', 'time_min', 'time_max']:
            renamed_col = f'{col.replace("(", "").replace(")", "").replace(" ", "_")}_{col_agg}'.lower()
            col_renamer[col] = renamed_col
        else:
            col_renamer[col] = col
    df_sheet_grouped = df_sheet_grouped.rename(columns=col_renamer)
    df_sheet_grouped['batch-date'] = 'Batch_' + df_sheet_grouped['Weighing times'].astype(str) + '_' + df_sheet_grouped[
        'day'].astype(str)
    df_sheet_grouped = round(df_sheet_grouped, 6)
    return df_sheet_grouped
