
def get_tags_function(pipeline_param: dict) -> dict:
    import pandas as pd
    from loguru import logger
    import warnings
    import tracemalloc
    import os
    from pymongo import MongoClient
    city = os.getenv("CITY")
    db_ = os.getenv("MONGO_DB")
    print(pipeline_param)
    print("--",pipeline_param["MONGO_URI"])
    # collections
    collection_ = os.getenv("MONGO_COLLECTION")
    mongo_uri_ = pipeline_param['MONGO_URI']
    print("mongo_uri",mongo_uri_)
    project_id_ = pipeline_param['PROJECT_ID']
    query_filter_ = pipeline_param['QUERY_FILTER']
    try:
        class MongoConstants:
            # DB
            db = db_
            # collections
            collection = collection_

        class Mongo:
            mongo_uri = mongo_uri_
            project_id = project_id_
            query_filter = query_filter_

        class MongoConnect:
            def __init__(self, uri, database, collection):
                try:
                    self.uri = uri
                    self.client = MongoClient(self.uri, connect=False)
                    self.database = database
                    self.collection = collection
                except Exception as e:
                    logger.exception(f'Exception - {e}')

            @staticmethod
            def data_dict(data, city):
                try:
                    req_dict = dict()
                    req_dict['project_id'] = Mongo.project_id
                    req_dict['id'] = Mongo.query_filter
                    req_dict['city'] = city
                    req_dict['input_data'] = data
                    return req_dict
                except Exception as e:
                    logger.exception(f'Exception - {e}')

            def insert_one(self, data, city):
                try:
                    db = self.client[self.database]
                    collection = db[self.collection]
                    req_dict = self.data_dict(data=data, city=city)
                    response = collection.insert_one(req_dict)
                    return response.inserted_id
                except Exception as e:
                    logger.exception(f'Exception - {e}')

            def find_one(self, query, filter_dict=None):
                try:
                    if filter_dict is None:
                        filter_dict = {"_id": 0}
                    db = self.client[self.database]
                    collection = db[self.collection]
                    response = collection.find_one(query, filter_dict)
                    return response
                except Exception as e:
                    logger.exception(f'Exception - {e}')

        mongo_conn = MongoConnect(uri=Mongo.mongo_uri, database=MongoConstants.db,
                                  collection=MongoConstants.collection)
        if mongo_conn is None:
            logger.info(f'mongodb is not connected, please check')
        else:
            logger.info(f'mongodb is connected, mongo conn - {mongo_conn}')

            df_raw_tags = pd.DataFrame.from_dict(mongo_conn.find_one({"$and": [{"id": "bgrimm_string_level_tags"},
                                                                               {"city": city},
                                                                               {"tags_property": "raw"}]})
                                                 ['input_data'], orient='index')

            df_predicted_tags = pd.DataFrame.from_dict(mongo_conn.find_one({"$and": [{"id": "bgrimm_string_level_tags"},
                                                                                     {"city": city},
                                                                                     {"tags_property": "predicted"}]})
                                                       ['input_data'], orient='index')

            df_raw_tags.reset_index(inplace=True)
            df_raw_tags.rename(columns={'index': 'tag_name'}, inplace=True)
            df_predicted_tags.reset_index(inplace=True)
            df_predicted_tags.rename(columns={'index': 'tag_name'}, inplace=True)

            try:
                # df_coefficients = pd.DataFrame.from_dict(
                #     mongo_conn.find_one({"$and": [{"id": "bgrimm_string_level_tags"},
                #                                   {"city": city},
                #                                   {"tags_property":
                #                                        "mppt_coefficients"}]})
                #     ['input_data'], orient='index')
                df_coefficients = pd.DataFrame()
            except Exception as er:
                logger.exception(f"Coefficient dataframe unavailable with message: {er}")
                df_coefficients = pd.DataFrame()

            del mongo_conn

            df_coefficients.reset_index(inplace=True)
            df_coefficients.rename(columns={'index': 'inv_id_mppt_id'}, inplace=True)

            tracemalloc.clear_traces()
            tracemalloc.get_traced_memory()
            final_dict = {"raw": df_raw_tags.to_dict('records'), "predicted": df_predicted_tags.to_dict('records'),
                          "coefficients": df_coefficients.to_dict('records')}
            print(final_dict)
            return final_dict
    except Exception as e:
        logger.exception(f'Exception - {e}')
