import json

from kfp.components import OutputPath


def get_tags_function(pipeline_param: dict, output_text_path: OutputPath(str)):
    import pandas as pd
    from loguru import logger
    import warnings
    import tracemalloc
    import os
    from pymongo import MongoClient
    city = os.getenv("CITY")
    db_ = os.getenv("MONGO_DB")
    print(pipeline_param)
    print("--", pipeline_param["MONGO_URI"])
    # collections
    collection_ = os.getenv("MONGO_COLLECTION")
    mongo_uri_ = pipeline_param['MONGO_URI']
    print("mongo_uri", mongo_uri_)
    project_id_ = pipeline_param['PROJECT_ID']
    query_filter_ = pipeline_param['QUERY_FILTER']
    try:

        class CommonConstants:
            bgrimm_string_level_tags = 'bgrimm_string_level_tags'
            panel_id = 'panel_id'
            sub_id = 'sub_id'
            inv_id_mppt_id = 'inv_id_mppt_id'
            tags_property_raw = 'raw'
            tags_property_predicted = 'predicted'
            tags_property_efficiency = 'efficiency'
            bgrim_tags_property_efficiency = 'Efficiency'
            tags_property_efficiency_inv = 'efficiency'
            tags_property_efficiency_plant = 'efficiency_plant'
            mppt_coefficients = 'mppt_coefficients'

        class MongoConstants:
            # DB
            db = db_
            # collections
            collection = collection_

        class Mongo:
            mongo_uri = mongo_uri_
            project_id = project_id_
            query_filter = query_filter_

        class MongoConnect:
            def __init__(self, uri, database, collection):
                try:
                    self.uri = uri
                    self.client = MongoClient(self.uri, connect=False)
                    self.database = database
                    self.collection = collection
                except Exception as e:
                    logger.exception(f'Exception - {e}')

            @staticmethod
            def data_dict(data, city):
                try:
                    req_dict = dict()
                    req_dict['project_id'] = Mongo.project_id
                    req_dict['id'] = Mongo.query_filter
                    req_dict['city'] = city
                    req_dict['input_data'] = data
                    return req_dict
                except Exception as e:
                    logger.exception(f'Exception - {e}')

            def insert_one(self, data, city):
                try:
                    db = self.client[self.database]
                    collection = db[self.collection]
                    req_dict = self.data_dict(data=data, city=city)
                    response = collection.insert_one(req_dict)
                    return response.inserted_id
                except Exception as e:
                    logger.exception(f'Exception - {e}')

            def find_one(self, query, filter_dict=None):
                try:
                    if filter_dict is None:
                        filter_dict = {"_id": 0}
                    db = self.client[self.database]
                    collection = db[self.collection]
                    response = collection.find_one(query, filter_dict)
                    return response
                except Exception as e:
                    logger.exception(f'Exception - {e}')

        tracemalloc.clear_traces()
        mongo_conn = MongoConnect(uri=Mongo.mongo_uri, database=MongoConstants.db,
                                  collection=MongoConstants.collection)
        if mongo_conn is None:
            logger.info(f'mongodb is not connected, please check')
        else:
            tracemalloc.clear_traces()
            logger.info(f'mongo conn - {mongo_conn}')

            df_raw_tags = pd.DataFrame.from_dict(mongo_conn.find_one({"$and": [
                {"id": CommonConstants.bgrimm_string_level_tags}, {"city": city},
                {"tags_property": CommonConstants.tags_property_raw}]})['input_data'], orient='index')

            df_predicted_tags = pd.DataFrame.from_dict(mongo_conn.find_one({"$and": [
                {"id": CommonConstants.bgrimm_string_level_tags}, {"city": city},
                {"tags_property": CommonConstants.tags_property_predicted}]})['input_data'], orient='index')

            df_efficiency_tags = pd.DataFrame.from_dict(mongo_conn.find_one({"$and": [
                {"id": CommonConstants.bgrimm_string_level_tags}, {"city": city},
                {"tags_property": CommonConstants.tags_property_efficiency}]})['input_data'], orient='index')

            df_raw_tags.reset_index(inplace=True)
            df_raw_tags.rename(columns={'index': 'tag_name'}, inplace=True)
            df_predicted_tags.reset_index(inplace=True)
            df_predicted_tags.rename(columns={'index': 'tag_name'}, inplace=True)
            df_efficiency_tags.reset_index(inplace=True)
            df_efficiency_tags.rename(columns={'index': 'tag_name'}, inplace=True)

            # df_coefficients = pd.DataFrame.from_dict(mongo_conn.find_one(
            #     {"$and": [{"id": CommonConstants.bgrimm_string_level_tags}, {"city": city},
            #               {"tags_property": CommonConstants.mppt_coefficients}]})['input_data'], orient='index')

            # df_coefficients.reset_index(inplace=True)
            # df_coefficients.rename(columns={'index': CommonConstants.inv_id_mppt_id}, inplace=True)

            df_coefficients = pd.DataFrame()
            tracemalloc.clear_traces()
            del mongo_conn
            final_dict = {"df_raw_tags": df_raw_tags.to_dict('records'),
                          "df_predicted_tags": df_predicted_tags.to_dict('records'),
                          "df_coefficients": df_coefficients.to_dict('records'),
                          "df_efficiency_tags": df_efficiency_tags.to_dict('records')}
            print(final_dict)
            with open(output_text_path, 'w') as f:
                json.dump(final_dict, f)
    except Exception as e:
        logger.exception(f'Exception - {e}')
