
def get_start_and_end_time() -> dict:
    from loguru import logger
    from datetime import datetime, timedelta
    import pytz
    import os

    class DateRange:
        start_relative_days = int(os.getenv("START_RELATIVE"))
        start_hour_relative = int(os.getenv("START_HOUR_RELATIVE"))
        day_starting_hour = int(os.getenv("DAY_STARTING_HOUR"))
        start_minute_relative = int(os.getenv("START_MINUTE_RELATIVE"))
        start_second_relative = int(os.getenv("START_SECOND_RELATIVE"))
        end_relative_days = int(os.getenv("END_RELATIVE"))
        end_hour_relative = int(os.getenv("END_HOUR_RELATIVE"))
        end_minute_relative = int(os.getenv("END_MINUTE_RELATIVE"))
        end_second_relative = int(os.getenv("END_SECOND_RELATIVE"))

    class ReqTimeZone:
        required_tz = os.getenv("REQUIRED_TZ")

    try:

        start_date = (datetime.now(pytz.utc) - timedelta(days=int(DateRange.start_relative_days),
                                                         hours=int(DateRange.start_hour_relative))). \
            astimezone(pytz.timezone(ReqTimeZone.required_tz)).replace(hour=int(DateRange.day_starting_hour),
                                                                       minute=int(DateRange.start_minute_relative),
                                                                       second=int(DateRange.start_second_relative),
                                                                       microsecond=0)

        end_date = (datetime.now(pytz.utc) - timedelta(days=int(DateRange.end_relative_days),
                                                       hours=int(DateRange.end_hour_relative))). \
            astimezone(pytz.timezone(ReqTimeZone.required_tz)).replace(minute=int(DateRange.end_minute_relative),
                                                                       second=int(DateRange.end_second_relative),
                                                                       microsecond=0)

        start_timestamp = int(start_date.timestamp()) * 1000
        end_timestamp = int(end_date.timestamp()) * 1000

        final_dict = {
                      "start_timestamp": start_timestamp,
                      "end_timestamp": end_timestamp}
        print(final_dict)
        return final_dict
    except Exception as e:
        logger.exception(f'Exception - {e}')
