from kfp.components import InputPath, OutputPath


def get_final_predicted_tags(input_path: InputPath(), output_path: OutputPath()):
    class CommonConstants:
        dalmia_string_level_tags = 'dalmia_string_level_tags'
        bgrimm_string_level_tags = 'bgrimm_string_level_tags'
        panel_id = 'panel_id'
        sub_id = 'sub_id'
        inv_id_mppt_id = 'inv_id_mppt_id'
        tags_property_raw = 'raw'
        tags_property_predicted = 'predicted'
        tags_property_efficiency = 'efficiency'
        bgrim_tags_property_efficiency = 'Efficiency'
        tags_property_efficiency_inv = 'efficiency'
        tags_property_efficiency_plant = 'efficiency_plant'
        mppt_coefficients = 'mppt_coefficients'
        inv_id = 'inv_id'
        mppt_id = 'mppt_id'
        datetime = 'datetime'
        predicted_current_mppt = 'predicted_current_mppt'
        predicted_current_mppt_tag = 'predicted_current_mppt_tag'
        actual_current_mppt = 'actual_current_mppt'
        hour = 'hour'
        skip_time = {"morning": {"start": 0, "end": 6},
                     "evening": {"start": 18, "end": 23}}
        efficiency_mppt = 'efficiency_mppt'
        efficiency_inv = 'efficiency_inv'
        efficiency_plant = 'efficiency_plant'
        tag_name = 'tag_name'
        parameter_name = 'parameter_name'
        timestamp = 'timestamp'
        tag_id = 'tag_id'
        efficiency_mppt_tag = 'efficiency_mppt_tag'
        voltage = 'voltage'
        current = 'current'
        Potential = 'Potential'
        Degradation = 'Degradation'
        tilt_irradiance = 'tilt_irradiance'
        voltage_mppt = 'voltage_mppt'
        current_mppt = 'current_mppt'
        date = 'date'
        asia_kolkata_timezone = 'Asia/Kolkata'
        asia_bangkok_timezone = 'Asia/Bangkok'
        coefficient = 'coefficient'
        cumulative_actual_current_mppt = 'cumulative_actual_current_mppt'
        cumulative_predicted_current_mppt = 'cumulative_predicted_current_mppt'
        day = "day"
        time = "time"

    import pandas as pd
    from loguru import logger
    import json

    try:
        with open(input_path, 'r') as f:
            get_tags_component_output_dict = json.load(f)
        print(get_tags_component_output_dict)
        df_predicted_tags = get_tags_component_output_dict.get("df_predicted_tags")
        df_efficiency_tags = get_tags_component_output_dict.get("df_efficiency_tags")
        df_predicted_tags = pd.DataFrame(df_predicted_tags)
        df_efficiency_tags = pd.DataFrame(df_efficiency_tags)
        df_predicted_tags = df_predicted_tags.copy()
        df_efficiency_tags_copy = df_efficiency_tags.copy()

        df_predicted_tags.rename(columns={CommonConstants.tag_id: CommonConstants.predicted_current_mppt_tag},
                                 inplace=True)

        df_efficiency_tags_copy.rename(columns={CommonConstants.tag_id: CommonConstants.efficiency_mppt_tag},
                                       inplace=True)

        df_predicted_tags[CommonConstants.inv_id_mppt_id] = df_predicted_tags[CommonConstants.sub_id] + '_' + \
                                                            df_predicted_tags[CommonConstants.inv_id] + '_' + \
                                                            df_predicted_tags[CommonConstants.mppt_id]

        df_efficiency_tags_copy[CommonConstants.inv_id_mppt_id] = df_efficiency_tags_copy[CommonConstants.sub_id] \
                                                                  + '_' + \
                                                                  df_efficiency_tags_copy[CommonConstants.inv_id] \
                                                                  + '_' + \
                                                                  df_efficiency_tags_copy[CommonConstants.mppt_id]

        df_predicted_and_efficiency_tags = pd.merge(df_predicted_tags,
                                                    df_efficiency_tags_copy[[CommonConstants.efficiency_mppt_tag,
                                                                             CommonConstants.inv_id_mppt_id]],
                                                    on=CommonConstants.inv_id_mppt_id,
                                                    how='left')
        df_predicted_and_efficiency_tags.reset_index(drop=True, inplace=True)
        final_dict = {"df_predicted_and_efficiency_tags": df_predicted_and_efficiency_tags.to_dict(orient="records")}
        with open(output_path, 'w') as f:
            json.dump(final_dict, f)
        print(final_dict)
    except Exception as e:
        logger.exception(f'Exception - {e}')
