import kfp
from kfp import dsl
from kubernetes import client as k8s_client
from kubernetes.client import (V1EnvVar)
from loguru import logger


@dsl.pipeline(name="Dalmia", description="All Components")
def forecast_pipeline(pipeline_param: dict, plant_info: dict):
    """

    :param pipeline_param:
    :param plant_info:
    :return:
    """
    try:
        # Loading the component from the above yaml file
        get_tags_function_component = kfp.components.load_component_from_file(
            "input_components/get_tags_component/component.yml")


        # Calling the component
        get_tags_function_task = get_tags_function_component(pipeline_param).set_memory_request('600M').set_memory_limit('1200M').\
            set_cpu_request('700m').set_cpu_limit('1400m')

        # get_tags_function_task.add_volume(k8s_client.V1Volume(
        #     name="get-data-volume",
        #     secret=k8s_client.V1SecretVolumeSource(secret_name="MONGO_URI"))
        # )
        #
        # get_tags_function_task.add_env_variable(
        #     V1EnvVar(
        #         name="MONGO_URI",
        #         value_from=k8s_client.V1EnvVarSource(secret_key_ref=k8s_client.V1SecretKeySelector(
        #             name="mongo-uri",
        #             key="MONGO_URI"
        #         )
        #         )
        #     )
        # )

        # Disabling cacheing for all the components
        get_tags_function_task.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # read_from_kairos_task.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # data_preprocess_task.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # get_forecast_data_task.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # write_data_processor_task_1.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # get_data_recaster_task.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # write_data_processor_task_2.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # get_rolling_avg_task.execution_options.caching_strategy.max_cache_staleness = "P0D"
        # write_data_processor_task_3.execution_options.caching_strategy.max_cache_staleness = "P0D"

    except Exception as e:
        logger.exception(f"Unable to Perform the execution {e}")


if __name__ == "__main__":
    kfp.compiler.Compiler().compile(forecast_pipeline, "pipeline.yml")
