from kfp.components import InputPath, OutputPath


def inv_and_level_efficiency_tags(input_path: InputPath(), output_path: OutputPath()):
    class CommonConstants:
        dalmia_string_level_tags = 'dalmia_string_level_tags'
        bgrimm_string_level_tags = 'bgrimm_string_level_tags'
        panel_id = 'panel_id'
        sub_id = 'sub_id'
        inv_id_mppt_id = 'inv_id_mppt_id'
        tags_property_raw = 'raw'
        tags_property_predicted = 'predicted'
        tags_property_efficiency = 'efficiency'
        bgrim_tags_property_efficiency = 'Efficiency'
        tags_property_efficiency_inv = 'efficiency'
        tags_property_efficiency_plant = 'efficiency_plant'
        mppt_coefficients = 'mppt_coefficients'
        inv_id = 'inv_id'
        mppt_id = 'mppt_id'
        datetime = 'datetime'
        predicted_current_mppt = 'predicted_current_mppt'
        predicted_current_mppt_tag = 'predicted_current_mppt_tag'
        actual_current_mppt = 'actual_current_mppt'
        hour = 'hour'
        skip_time = {"morning": {"start": 0, "end": 6},
                     "evening": {"start": 18, "end": 23}}
        efficiency_mppt = 'efficiency_mppt'
        efficiency_inv = 'efficiency_inv'
        efficiency_plant = 'efficiency_plant'
        tag_name = 'tag_name'
        parameter_name = 'parameter_name'
        timestamp = 'timestamp'
        tag_id = 'tag_id'
        efficiency_mppt_tag = 'efficiency_mppt_tag'
        voltage = 'voltage'
        current = 'current'
        Potential = 'Potential'
        Degradation = 'Degradation'
        tilt_irradiance = 'tilt_irradiance'
        voltage_mppt = 'voltage_mppt'
        current_mppt = 'current_mppt'
        date = 'date'
        asia_kolkata_timezone = 'Asia/Kolkata'
        asia_bangkok_timezone = 'Asia/Bangkok'
        coefficient = 'coefficient'
        cumulative_actual_current_mppt = 'cumulative_actual_current_mppt'
        cumulative_predicted_current_mppt = 'cumulative_predicted_current_mppt'
        day = "day"
        time = "time"

    import pandas as pd
    from loguru import logger
    import json

    try:
        with open(input_path, 'r') as f:
            get_tags_component_output_dict = json.load(f)
        print(get_tags_component_output_dict)
        df_efficiency_tags = get_tags_component_output_dict.get("df_efficiency_tags")
        df_efficiency_tags = pd.DataFrame(df_efficiency_tags)
        df_inv_tags = \
            df_efficiency_tags[(df_efficiency_tags[CommonConstants.parameter_name] ==
                                CommonConstants.bgrim_tags_property_efficiency) &
                               (df_efficiency_tags[CommonConstants.mppt_id] ==
                                CommonConstants.bgrim_tags_property_efficiency)]
        inv_substring = 'INVERTER'
        data_with_substring = [data for data in df_inv_tags['inv_id'] if inv_substring in data]
        df_inv_tags = df_inv_tags.loc[df_inv_tags['inv_id'].isin(data_with_substring)]
        df_inv_tags.reset_index(drop=True, inplace=True)

        df_plant_tag = \
            df_efficiency_tags[(df_efficiency_tags[CommonConstants.parameter_name] ==
                                CommonConstants.bgrim_tags_property_efficiency)
                               & (df_efficiency_tags[CommonConstants.mppt_id] ==
                                  CommonConstants.bgrim_tags_property_efficiency)]
        data_with_no_substring = [data for data in df_plant_tag['inv_id'] if inv_substring not in data]
        df_plant_tag = df_plant_tag.loc[df_plant_tag['inv_id'].isin(data_with_no_substring)]
        df_plant_tag.reset_index(drop=True, inplace=True)

        plant_efficiency_tag = df_plant_tag.iloc[0, df_plant_tag.columns.get_loc(CommonConstants.tag_id)]
        logger.info(f'total no of inv level efficiency tags - {df_inv_tags.shape}')
        logger.info(f'total no of plant level efficiency tags - {df_plant_tag.shape}')
        final_dict = {"df_inv_tags": df_inv_tags.to_dict(orient="records"),
                      "plant_efficiency_tag": plant_efficiency_tag}
        with open(output_path, 'w') as f:
            json.dump(final_dict, f)
        print(final_dict)
    except Exception as e:
        logger.exception(f'Exception - {e}')
