import kfp
from kfp import dsl
from kubernetes import client as k8s_client
from kubernetes.client import (V1EnvVar)
from loguru import logger


@dsl.pipeline(name="Dalmia", description="All Components")
def forecast_pipeline(pipeline_param: dict, plant_info: dict):
    """

    :param pipeline_param:
    :param plant_info:
    :return:
    """
    try:
        # Loading the component from the above yaml file
        get_tags_function_component = kfp.components.load_component_from_file(
            "input_components/get_tags_component/component.yml")
        get_final_predicted_tags = kfp.components.load_component_from_file(
            "input_components/get_final_predicted_tags/component.yml")
        get_inv_and_level_efficiency_tags = kfp.components.load_component_from_file(
            "input_components/get_inv_and_level_efficiency_tags/component.yml")
        # Calling the component
        get_tags_function_task = get_tags_function_component(pipeline_param).set_memory_request('600M').set_memory_limit('1200M').\
            set_cpu_request('700m').set_cpu_limit('1400m')
        get_final_predicted_tags_task = get_final_predicted_tags(get_tags_function_task.output)
        get_inv_and_level_efficiency_tags_task = get_inv_and_level_efficiency_tags(get_tags_function_task.output)

        # Disabling cacheing for all the components
        get_tags_function_task.execution_options.caching_strategy.max_cache_staleness = "P0D"

    except Exception as e:
        logger.exception(f"Unable to Perform the execution {e}")


if __name__ == "__main__":
    kfp.compiler.Compiler().compile(forecast_pipeline, "pipeline.yml")
