import kfp
from loguru import logger
from src import program
import yaml
import inspect
import os

function = \
    [func[1] for func in inspect.getmembers(program, inspect.isfunction) if inspect.getmodule(func[1]) == program][0]


def read_data_from_yaml(path):
    """
    It opens the file at the given path, reads the contents, and then parses the contents as YAML

    :param path: The path to the YAML file
    :return: A dictionary
    """
    with open(path, "r") as stream:
        return yaml.load(stream, Loader=yaml.FullLoader)


def get_component_yml():
    """

    :param file_name:
    :return:
    """
    try:
        requirements = list()
        with open('requirements.txt', 'r') as file:
            for line in file:
                if "=" in line and "#" not in line:
                    requirements.append(line.strip())
                elif "#" in line:
                    ...
                else:
                    logger.exception(f"Mentioned package does not have version {line.strip()}")

        date_function_yml = kfp.components.func_to_component_text(
            function, packages_to_install=requirements)

        variables_path = "variables.yml"

        if os.path.exists(variables_path):

            yaml_data: dict = read_data_from_yaml(variables_path)
            if yaml_data:
                envs: dict = yaml_data.get("deployment", {}).get("environmentVar", [])
                python_version: str = yaml_data.get("deployment", {}).get("pythonVersion", None)
                if python_version is not None and python_version in ["3.7", "3.8", "3.9", "3.10"]:
                    date_function_yml = kfp.components.func_to_component_text(
                        function, packages_to_install=requirements, base_image=f"python:{python_version}")
                date_function = date_function_yml + f"    env:\n"
                for env_var in envs:
                    date_function += f"      {env_var['name']}: '{env_var['value']}'\n"
                with open('component.yml', 'w') as file:
                    file.write(date_function)
            else:
                with open('component.yml', 'w') as file:
                    file.write(date_function_yml)
        else:
            with open('component.yml', 'w') as file:
                file.write(date_function_yml)



    except Exception as e:
        logger.exception(f"Unable to get the component yml {e}")


def create_table(data, key):
    """

    :return:
    """
    try:
        rows_list = list()
        for each_input in data.get(key, []):
            rows_dict = dict()
            rows_dict['name'] = each_input.get("name", '')
            rows_dict['data_type'] = each_input.get('type', 'String')
            if each_input.get('optional'):
                req_opt = "Optional"
                default_value = each_input.get('default', '')
            else:
                req_opt = "Required"
                default_value = "None"
            rows_dict['req_opt'] = req_opt
            rows_dict['default_value'] = default_value

            for each_arg in data.get('implementation', {}).get('container', {}).get('args', []):
                if type(each_arg) == dict and rows_dict['name'] in each_arg.values():
                    rows_dict['Type'] = list(each_arg.keys())[0]
                    rows_dict['Description'] = each_input.get('description', '')
                    rows_dict['Example'] = ''

            rows_list.append(list(rows_dict.values()))

        if key == "inputs" and os.path.exists("variables.yml"):
            yaml_data: dict = read_data_from_yaml("variables.yml")
            if yaml_data:
                env_var = yaml_data.get("deployment", {}).get("environmentVar", [])
                for each in env_var:
                    env_dict = dict()
                    env_dict['name'] = each.get("name")
                    env_dict['data_type'] = "String"
                    env_dict['req_opt'] = "Required"
                    env_dict['default_value'] = "None"
                    env_dict['Type'] = "env"
                    env_dict['description'] = ""
                    env_dict['example'] = ""
                    rows_list.append(list(env_dict.values()))

        return rows_list
    except Exception as e:
        logger.exception(f"Unable to create the table for README.MD file {e}")


def create_readme():
    """
    Function is to create the readme file for the given components details
    :return: Create the README.MD file in the given path
    """
    try:

        note_1 = "Note 1 : Available Component types are: Input, Transform, Output."

        note_2 = "Note 2 : Available Environment types are: env, InputValues, InputPath, OutputValues," \
                 " OutputPath, PipelineParm"

        column_list = ["Variable Name", "Datatype", "Required/Optional", "Default Value", "Type", "Description",
                       "Example"]

        with open("component.yml", "r") as file:
            data = yaml.safe_load(file)

        if "inputs" in list(data.keys()) and "outputs" in list(data.keys()):
            component_type = "Transform type"
        elif "inputs" not in data:
            component_type = "Input type"
        else:
            component_type = "Output type"

        component_overview_json = dict()

        component_overview_json['Component Name'] = data.get("name", " ")
        component_overview_json['Component Description'] = data.get("description", " ")
        component_overview_json['Component Type'] = component_type

        rows_list_input = create_table(data, "inputs")
        rows_list_output = create_table(data, "outputs")

        rows_list = rows_list_input + rows_list_output

        header = component_overview_json.get("Component Name")

        table_header = " |".join(column_list) + "\n"
        table_line = "--- |" * len(column_list) + "\n"
        table_body = "\n".join(map(lambda x: " |".join(x), rows_list))
        table = table_header + table_line + table_body
        readme = f"""
# {header}

## {"Overview"}

- **Component Name** : {component_overview_json.get("Component Name")}
- **Component Description** : {component_overview_json.get("Component Description")}
- **Component Type** : {component_overview_json.get("Component Type")}


## Component Param

{table}

> {note_1}

> {note_2}

        """

        with open('README.md', 'w') as f:
            f.write(readme)


    except Exception as e:
        logger.exception(f"Unable to create the README.MD file {e}")


if __name__ == "__main__":
    get_component_yml()
    create_readme()
