import traceback
from azure.storage.blob import BlobServiceClient
from scripts.common.config_parser import *
from scripts.common.constants import AzureUploadBlobConstants, ComponentExceptions
from scripts.common.logsetup import logger


class AzureUpload:
    def __init__(self):
        self.container = AzureUploadBlobConstants.CONTAINER
        self.connection_string = AzureUploadBlobConstants.CONNECTION_STRING
        self.blob_service_client = BlobServiceClient.from_connection_string(self.connection_string)
        self.container_client = self.blob_service_client.get_container_client(self.container)

    def upload_to_blob(self, query):
        try:
            logger.info("Creating Connection........")
            blob_client = self.blob_service_client.get_blob_client(container=self.container,
                                                                   blob=query[AzureUploadBlobConstants.AZURE_FILE_PATH])
            with open(query[AzureUploadBlobConstants.LOCAL_FILE_PATH], "rb") as data:
                blob_client.upload_blob(data, overwrite=True)
            logger.info("Started uploading file at path " + query[AzureUploadBlobConstants.LOCAL_FILE_PATH] + " is uploaded at path " + query[AzureUploadBlobConstants.AZURE_FILE_PATH] + " on azure")
            return True
        except Exception as e:
            raise Exception(e)


if __name__ == '__main__':
    try:
        if AzureUploadBlobConstants.AZURE_FILE_PATH in config.keys():
            azure_file_path = config[AzureUploadBlobConstants.AZURE_FILE_PATH]
        else:
            raise Exception(ComponentExceptions.INVALID_AZURE_FILE_PATH_EXCEPTION)
        if AzureUploadBlobConstants.LOCAL_FILE_PATH in config.keys():
            local_file_path = config[AzureUploadBlobConstants.LOCAL_FILE_PATH]
        else:
            raise Exception(ComponentExceptions.INVALID_LOCAL_FILE_PATH_EXCEPTION)
        obj = AzureUpload()
        val = obj.upload_to_blob(config)
        if val:
            logger.info("File Uploaded Successfully")
    except:
        logger.info("Web Component Failed")
        logger.info(traceback.format_exc())
