import traceback
from azure.storage.blob import BlobServiceClient
from scripts.common.config_parser import *
from scripts.common.constants import AzureDownloadBlobConstants, ComponentExceptions
from scripts.common.logsetup import logger


class AzureDownload:
    def __init__(self):
        self.container = AzureDownloadBlobConstants.CONTAINER
        self.connection_string = AzureDownloadBlobConstants.CONNECTION_STRING
        self.blob_service_client = BlobServiceClient.from_connection_string(self.connection_string)
        self.container_client = self.blob_service_client.get_container_client(self.container)

    def upload_to_blob(self, query):
        try:
            logger.info("Creating Connection........")
            blob_client = self.blob_service_client.get_blob_client(container=self.container,
                                                                   blob=query[AzureDownloadBlobConstants.AZURE_FILE_PATH])
            with open(query[AzureDownloadBlobConstants.LOCAL_FILE_PATH], "wb") as download_file:
                download_file.write(blob_client.download_blob().readall())
            logger.info("Started downloading file to path " + query[AzureDownloadBlobConstants.LOCAL_FILE_PATH] + " from path " + query[AzureDownloadBlobConstants.AZURE_FILE_PATH] + " on azure")
            return True
        except Exception as e:
            raise Exception(e)


if __name__ == '__main__':
    try:
        if AzureDownloadBlobConstants.AZURE_FILE_PATH in config.keys():
            azure_file_path = config[AzureDownloadBlobConstants.AZURE_FILE_PATH]
        else:
            raise Exception(ComponentExceptions.INVALID_AZURE_FILE_PATH_EXCEPTION)
        if AzureDownloadBlobConstants.LOCAL_FILE_PATH in config.keys():
            local_file_path = config[AzureDownloadBlobConstants.LOCAL_FILE_PATH]
        else:
            raise Exception(ComponentExceptions.INVALID_LOCAL_FILE_PATH_EXCEPTION)
        obj = AzureDownload()
        val = obj.upload_to_blob(config)
        if val:
            logger.info("File Downloaded Successfully")
    except:
        logger.info("Azure File Download Component Failed")
        logger.info(traceback.format_exc())
