#!/usr/bin/env python
import os
import sys
import yaml
import json
from pymongo import MongoClient, DESCENDING
from scripts.common.constants import AddtoModelStoreConstants

config_path = os.path.join(os.getcwd(), "conf", "configuration.yml")
if os.path.exists(config_path):
    sys.stderr.write("Reading config from --> {}".format(config_path))
    sys.stderr.write("\n")

    with open(config_path, 'r') as stream:
        _config = yaml.safe_load(stream)
else:
    sys.stderr.write("Configuration not found...")
    sys.stderr.write("Exiting....")
    sys.exit(1)
# uncomment for Testing
# os.environ['pipeline_id'] = "pipe1"
# os.environ['artifact_base_path'] = "/data/ai-models"
# os.environ['ilens_tag_hierarchy'] = 'site1'
# os.environ['container_name'] = 'test'
# ------------------------ Configurations -----------------------------------------------------------------------------
pipeline_id = os.environ.get('PIPELINE_ID', default="pipeline_313")
shared_mount_base_ai_job = os.environ.get("shared_mount_base_ai_job",
                                          _config.get("SYSTEM_CONFIG", {}).get('shared_mount_base_ai_job'))
# read from $shared_mount_base_ai_job/$pipeline_id/run.config
# run_id_path = shared_mount_base_ai_job + "/" + pipeline_id + "/run_config.json"
run_id_path = os.path.join(shared_mount_base_ai_job, pipeline_id, "run_config.json")

metadata_path = os.path.join(shared_mount_base_ai_job, "models")
try:
    sys.stderr.write("Checking for run id parameters at path " + run_id_path + "\n")
    with open(run_id_path) as f:
        run_id_param = json.load(f)
    run_id = run_id_param['run_id']
except Exception as e:
    sys.stderr.write("No run_config.json file is there so keeping run id as default_run_id  " + "\n")
    run_id = _config.get("SYSTEM_CONFIG", {}).get('default_run_id')

data_store = os.environ.get('data_store', default="Azure")

container_name = os.environ.get('container_name', default=AddtoModelStoreConstants.CONTAINER)

# change prod to test for testing
connection_string = os.environ.get('connection_string', _config.get("SYSTEM_CONFIG", {}).get('test_connection_string'))

artifact_base_path = os.environ.get('artifact_base_path')
artifact_current_path = os.path.join(artifact_base_path, "current")
artifact_archived_path = os.path.join(artifact_base_path, "archived")
# Component Parameter:Read from $shared_mount_base_ai_job/$pipeline_id/$run_id/GetDataFromStore/param.json
# component_parameter_path = shared_mount_base_ai_job + "/" + pipeline_id + "/" + run_id + "/" +
# GetDataFromStoreConstants.COMPONENT_NAME + "/param.json"
component_parameter_path = os.path.join(shared_mount_base_ai_job, pipeline_id, run_id,
                                        AddtoModelStoreConstants.COMPONENT_NAME, "param.json")

# shared_mount_base_ai_job/$pipeline_id/$run_id/AddtoModelStore/input/
component_input_dir = os.path.join(shared_mount_base_ai_job, pipeline_id, run_id,
                                   AddtoModelStoreConstants.COMPONENT_NAME, "input")
try:
    sys.stderr.write("Checking for component parameters at path " + component_parameter_path + "\n")
    with open(component_parameter_path) as f:
        component_parameter = json.load(f)
    ilens_tag_hierarchy = component_parameter['ilens_tag_hierarchy']
except Exception as e:
    sys.stderr.write("No param.json file so trying to take from env" + "\n")
    try:
        ilens_tag_hierarchy = os.environ.get('ilens_tag_hierarchy')
    except Exception as e:
        raise KeyError(e)

BASE_LOG_PATH = os.path.join(os.getcwd(), "logs")
if not os.path.exists(os.path.join(os.getcwd(), 'logs')):
    os.mkdir(os.path.join(os.getcwd(), 'logs'))

LOG_LEVEL = os.environ.get("LOG_LEVEL", _config.get('SERVICE_CONFIG', {}).get("LOG_LEVEL", "INFO")).upper()
LOG_HANDLER_NAME = _config.get('SERVICE_CONFIG', {}).get("LOG_HANDLER_NAME", "AddtoModelStore")
ENABLE_LOGSTASH_LOG = os.environ.get("ENABLE_LOGSTASH_LOG", 'False').lower()
LOGSTASH_HOST = _config.get('SERVICE_CONFIG', {}).get('LOGSTASH_HOST')
LOGSTASH_PORT = str(_config.get('SERVICE_CONFIG', {}).get('LOGSTASH_PORT'))

config = {
    'pipeline_id': pipeline_id,
    'run_id': run_id,
    'shared_mount_base_ai_job': shared_mount_base_ai_job,
    'data_store': data_store.lower(),
    'container_name': container_name,
    'artifact_base_path': artifact_base_path,
    'ilens_tag_hierarchy': ilens_tag_hierarchy,
    'connection_string': connection_string,
    'component_input_dir': component_input_dir,
    'artifact_current_path': artifact_current_path,
    'artifact_archived_path': artifact_archived_path,
    'metadata_path': metadata_path,
    'metadata_file': os.path.join(metadata_path, 'metadata.json')
}

if not os.path.exists(config['shared_mount_base_ai_job']):
    sys.stderr.write("Shared path does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['shared_mount_base_ai_job'] + "\n"))
    os.makedirs(config['shared_mount_base_ai_job'])

if not os.path.exists(config['metadata_path']):
    sys.stderr.write("MetaData path does not exist!" + "\n")
    sys.stderr.write("Creating path --> {}".format(config['metadata_path'] + "\n"))
    os.makedirs(config['metadata_path'])
