import { Injector, NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { createCustomElement } from '@angular/elements';
import { HttpClientModule } from '@angular/common/http';
import { FormsModule } from '@angular/forms';
import { NgSelectModule } from '@ng-select/ng-select';
import { SwitchInputComponent } from './switch-input/switch-input.component';
import { TagInputModule } from 'ngx-chips';
import { DesignTabComponent } from './chart-config/design-tab/design-tab.component';
import { ChartDisplayComponent } from './chart-display/chart-display.component';

@NgModule({
  declarations: [
    AppComponent,
    SwitchInputComponent,
    DesignTabComponent,
    ChartDisplayComponent
  ],
  imports: [
    BrowserModule,
    AppRoutingModule,
    HttpClientModule,
    FormsModule,
    NgSelectModule,
    TagInputModule,
  ],
  providers: [],
  bootstrap: []
})
export class AppModule {

  constructor(private injector: Injector) { }
  ngDoBootstrap() {
    if (!customElements.get('app-candle')) {
      const el = createCustomElement(AppComponent, { injector: this.injector })
      customElements.define('app-candle', el);
    }

  }
}
