import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';

@Component({
  selector: 'app-design-tab',
  templateUrl: './design-tab.component.html',
  styleUrls: ['./design-tab.component.scss']
})
export class DesignTabComponent implements OnInit {

  @Input() widgetInfo: any;

  @Output() widgetInfoChange = new EventEmitter();

  @Input() base_proxy: any;

  public baseOptions: any = {
    visualMap: {
      show: false,
      inRangeColors: ['#313695', '#4575b4', '#74add1', '#abd9e9', '#e0f3f8',
        '#ffffbf', '#fee090', '#fdae61', '#f46d43', '#d73027', '#a50026'],
    },
    tooltip: {
      show: true,
      backgroundColor: '#ffffff',
      borderColor: '#000000',
      borderWidth: 1,
      trigger: 'axis',
      axisPointer: {
        type: 'cross',
      },
      textStyle: {
        color: '#000000',
      },
    },
    dataZoom: {
      insideZoom: true,
      xAxis: false,
      yAxis: false,
      yAxisPos: 'left',
      xAxisPos: 'top',
    },
  }
  get _chartConfig() {
    return this.widgetInfo?.cData?.chartOptions ? this.widgetInfo.cData.chartOptions : this.baseOptions
  }


  set _chartConfig(value) {
    this.widgetInfo.cData.chartOptions = value;
    this.widgetInfoChange.emit(this.widgetInfo);
  }
  public chartComponentTemplates: any = [
    {
      label: 'Placement',
      value: 'placement',
      class: 'addYaxisAction'
    },
    {
      label: 'Data Tooltip',
      value: 'dataTooltip',
    },
    {
      label: 'Visual Map',
      value: 'visualMap',
    },
    {
      label: 'Data Zooming',
      value: 'dataZooming',
    },
  ]

  public chartOptions = {
    widgetPosition: [
      {
        label: 'Standard',
        value: 'standard',
      },
      {
        label: 'Flexible',
        value: 'flexible',
      },
    ],
    colWidth: [
      {
        label: '2',
        value: '2',
      },
      {
        label: '3',
        value: 3,
      },
      {
        label: '4',
        value: 4,
      },
      {
        label: '5',
        value: 5,
      },
      {
        label: '6',
        value: 6,
      },
      {
        label: '7',
        value: 7,
      },
      {
        label: '8',
        value: 8,
      },
      {
        label: '9',
        value: 9,
      },
      {
        label: '10',
        value: 10,
      },
      {
        label: '11',
        value: 11,
      },
      {
        label: '12',
        value: 12,
      },
    ],
    dataZoom: {
      yAxisPos: [
        { value: 'left', label: 'Left' },
        { value: 'right', label: 'Right' },
      ],
      xAxisPos: [
        { value: 'top', label: 'Top' },
        { value: 'bottom', label: 'Bottom' },
      ],
    },
    visualMapTypes: [
      {
        label: 'Continuous',
        value: 'continuous',
      },
      {
        label: 'Piece Wise',
        value: 'piecewise',
      },
    ],
    tooltip: {
      axisPointerTypes: [
        {
          label: 'Cross',
          value: 'cross',
        },
        {
          label: 'Line',
          value: 'line',
        },
        {
          label: 'Shadow',
          value: 'shadow',
        },
        {
          label: 'None',
          value: 'none',
        },
      ],
      triggerTypes: [
        {
          label: 'Item',
          value: 'item',
        },
        {
          label: 'Axis',
          value: 'axis',
        },
      ],
    },
  }
  constructor() { }

  ngOnInit() {
    for (const item of ['tooltip', 'dataZoom', 'visualMap']) {
      this._chartConfig[item] ??= this.baseOptions[item];
    }
  }

  emitChanges() { }

  addVisualMapRange() {
    try {
      this._chartConfig.visualMap.pieces ??= [];
      this._chartConfig.visualMap.pieces.push({ gt: '', lte: '', color: '' });
    } catch (error) {
      console.log(error);
    }
  }
  deleteChartLimit(index: any) {
    try {
      if (!this._chartConfig.visualMap.pieces || !this._chartConfig.visualMap.pieces[index]) {
        return;
      }
      this._chartConfig.visualMap.pieces.splice(index, 1);
    } catch (error) {
      console.log(error);
    }
  }

  isAttributeShow(a: any) {
    return true;
  }
}
