import json
import logging
import os

from fastapi.responses import FileResponse
from scripts.config import Service, PathToDir
from scripts.core.schemas.response_models import DefaultResponse
from scripts.core.schemas.response_models import LoadStylesResponse


class DefaultHandler:

    @staticmethod
    def load_styles():
        try:
            response = LoadStylesResponse()
            for each_file in os.listdir(Service.BUILD_DIR):
                path = f"{Service.PROXY}/widget/load_file?filename={each_file}"
                if each_file.endswith(".js"):
                    response.js_files.append(path)
                elif each_file.endswith(".css"):
                    response.styles.append(path)
                elif each_file == "assets":
                    response.assetPath = f"{Service.BUILD_DIR}/{each_file}"

            return DefaultResponse(message="Styles loaded successfully", data=response)
        except Exception as e:
            logging.exception(e)
            return DefaultResponse(message="Failed to load file paths", status="failed")

    @staticmethod
    def download_resources(filename: str):
        try:
            file_path = os.path.join(Service.BUILD_DIR, filename)
            if os.path.isfile(os.path.join(Service.BUILD_DIR, filename)) and filename.endswith(".js"):
                return FileResponse(file_path, media_type='application/octet-stream', filename=filename)
            else:
                return DefaultResponse(message="Failed to load resources")
        except Exception as e:
            logging.error("Exception " + str(e))
            return DefaultResponse(message="Filename is not available")

    @staticmethod
    def load_configuration():
        try:
            with open(f"{PathToDir.ASSETS}/widgetConfig.json", "r") as file:
                file_content = json.loads(file.read())
            return file_content
        except Exception as e:
            logging.error(e)
            return DefaultResponse(message="Failed to load configurations")

    @staticmethod
    def fetch_data():

        return {"data": {
            'site_637$tag_241': {'24/09/2023 00:00:59': 709.0, '24/09/2023 00:02:59': 800.0,
                                 '24/09/2023 00:04:59': 624.0,
                                 '24/09/2023 00:07:00': 273.0, '24/09/2023 00:09:00': 824.0,
                                 '24/09/2023 00:10:59': 173.0,
                                 '24/09/2023 00:13:00': 282.0, '24/09/2023 00:15:00': 492.0,
                                 '24/09/2023 00:16:59': 152.0,
                                 '24/09/2023 00:19:00': 645.0, '24/09/2023 00:20:59': 179.0,
                                 '24/09/2023 00:22:59': 875.0,
                                 '24/09/2023 00:25:00': 8.0, '24/09/2023 00:26:59': 554.0, '24/09/2023 00:29:00': 741.0,
                                 '24/09/2023 00:30:59': 108.0, '24/09/2023 00:32:59': 365.0,
                                 '24/09/2023 00:34:59': 244.0,
                                 '24/09/2023 00:36:59': 356.0, '24/09/2023 00:39:00': 471.0,
                                 '24/09/2023 00:40:59': 733.0,
                                 '24/09/2023 00:42:59': 541.0, '24/09/2023 00:44:59': 74.0, '24/09/2023 00:46:59': 54.0,
                                 '24/09/2023 00:48:59': 340.0, '24/09/2023 00:50:59': 595.0,
                                 '24/09/2023 00:53:00': 576.0,
                                 '24/09/2023 00:55:00': 206.0, '24/09/2023 00:56:59': 178.0,
                                 '24/09/2023 00:59:00': 231.0,
                                 '24/09/2023 01:00:59': 133.0, '24/09/2023 01:02:59': 166.0,
                                 '24/09/2023 01:04:59': 91.0,
                                 '24/09/2023 01:06:59': 256.0, '24/09/2023 01:09:00': 27.0,
                                 '24/09/2023 01:10:59': 298.0,
                                 '24/09/2023 01:12:59': 262.0, '24/09/2023 01:15:00': 471.0,
                                 '24/09/2023 01:16:59': 605.0,
                                 '24/09/2023 01:19:00': 774.0, '24/09/2023 01:21:00': 119.0,
                                 '24/09/2023 01:23:00': 332.0,
                                 '24/09/2023 01:24:59': 635.0, '24/09/2023 01:27:00': 40.0, '24/09/2023 01:29:00': 89.0,
                                 '24/09/2023 01:30:59': 145.0, '24/09/2023 01:33:00': 304.0,
                                 '24/09/2023 01:34:59': 740.0,
                                 '24/09/2023 01:37:00': 679.0, '24/09/2023 01:39:00': 600.0,
                                 '24/09/2023 01:41:00': 650.0,
                                 '24/09/2023 01:43:00': 202.0, '24/09/2023 01:44:59': 279.0,
                                 '24/09/2023 01:46:59': 884.0,
                                 '24/09/2023 01:49:00': 585.0, '24/09/2023 01:50:59': 888.0, '24/09/2023 01:52:59': 5.0,
                                 '24/09/2023 01:55:00': 589.0, '24/09/2023 01:56:59': 148.0,
                                 '24/09/2023 01:59:00': 495.0,
                                 '24/09/2023 02:00:59': 791.0, '24/09/2023 02:02:59': 659.0,
                                 '24/09/2023 02:04:59': 825.0,
                                 '24/09/2023 02:06:59': 451.0, '24/09/2023 02:09:00': 348.0,
                                 '24/09/2023 02:11:00': 300.0,
                                 '24/09/2023 02:13:00': 393.0, '24/09/2023 02:14:59': 523.0,
                                 '24/09/2023 02:16:59': 91.0,
                                 '24/09/2023 02:18:59': 365.0, '24/09/2023 02:20:59': 139.0,
                                 '24/09/2023 02:22:59': 543.0,
                                 '24/09/2023 02:25:00': 920.0, '24/09/2023 02:26:59': 972.0,
                                 '24/09/2023 02:28:59': 576.0,
                                 '24/09/2023 02:30:59': 768.0, '24/09/2023 02:33:00': 745.0,
                                 '24/09/2023 02:34:59': 22.0,
                                 '24/09/2023 02:37:00': 763.0, '24/09/2023 02:38:59': 698.0,
                                 '24/09/2023 02:41:00': 521.0,
                                 '24/09/2023 02:43:00': 536.0, '24/09/2023 02:44:59': 302.0,
                                 '24/09/2023 02:46:59': 156.0,
                                 '24/09/2023 02:49:00': 543.0, '24/09/2023 02:50:59': 992.0,
                                 '24/09/2023 02:53:00': 1000.0,
                                 '24/09/2023 02:55:00': 518.0, '24/09/2023 02:56:59': 30.0,
                                 '24/09/2023 02:59:00': 866.0,
                                 '24/09/2023 03:00:59': 341.0, '24/09/2023 03:03:00': 35.0,
                                 '24/09/2023 03:04:59': 710.0,
                                 '24/09/2023 03:07:00': 875.0, '24/09/2023 03:09:00': 688.0,
                                 '24/09/2023 03:10:59': 33.0,
                                 '24/09/2023 03:13:00': 920.0, '24/09/2023 03:14:59': 733.0,
                                 '24/09/2023 03:17:00': 64.0,
                                 '24/09/2023 03:19:00': 863.0, '24/09/2023 03:20:59': 605.0,
                                 '24/09/2023 03:22:59': 643.0,
                                 '24/09/2023 03:25:00': 43.0, '24/09/2023 03:26:59': 712.0,
                                 '24/09/2023 03:29:00': 444.0,
                                 '24/09/2023 03:31:00': 18.0, '24/09/2023 03:32:59': 84.0, '24/09/2023 03:34:59': 837.0,
                                 '24/09/2023 03:37:00': 185.0, '24/09/2023 03:39:00': 761.0,
                                 '24/09/2023 03:41:00': 645.0,
                                 '24/09/2023 03:42:59': 983.0, '24/09/2023 03:44:59': 231.0,
                                 '24/09/2023 03:46:59': 165.0,
                                 '24/09/2023 03:48:59': 576.0, '24/09/2023 03:50:59': 700.0,
                                 '24/09/2023 03:53:00': 411.0,
                                 '24/09/2023 03:55:00': 541.0, '24/09/2023 03:57:00': 248.0,
                                 '24/09/2023 03:59:00': 97.0,
                                 '24/09/2023 04:00:59': 551.0, '24/09/2023 04:03:00': 304.0,
                                 '24/09/2023 04:05:00': 24.0,
                                 '24/09/2023 04:07:00': 754.0, '24/09/2023 04:09:00': 63.0,
                                 '24/09/2023 04:11:00': 400.0,
                                 '24/09/2023 04:13:00': 988.0, '24/09/2023 04:15:00': 389.0,
                                 '24/09/2023 04:16:59': 886.0,
                                 '24/09/2023 04:19:00': 765.0, '24/09/2023 04:20:59': 138.0,
                                 '24/09/2023 04:22:59': 25.0,
                                 '24/09/2023 04:25:00': 808.0, '24/09/2023 04:26:59': 543.0,
                                 '24/09/2023 04:29:00': 675.0,
                                 '24/09/2023 04:31:00': 293.0, '24/09/2023 04:32:59': 286.0,
                                 '24/09/2023 04:34:59': 198.0,
                                 '24/09/2023 04:37:00': 632.0, '24/09/2023 04:39:00': 734.0,
                                 '24/09/2023 04:40:59': 192.0,
                                 '24/09/2023 04:42:59': 297.0, '24/09/2023 04:45:00': 497.0,
                                 '24/09/2023 04:47:00': 815.0,
                                 '24/09/2023 04:49:00': 136.0, '24/09/2023 04:50:59': 412.0,
                                 '24/09/2023 04:53:00': 620.0,
                                 '24/09/2023 04:54:59': 740.0, '24/09/2023 04:56:59': 429.0,
                                 '24/09/2023 04:58:59': 860.0,
                                 '24/09/2023 05:00:59': 449.0, '24/09/2023 05:03:00': 475.0,
                                 '24/09/2023 05:05:00': 852.0,
                                 '24/09/2023 05:06:59': 849.0, '24/09/2023 05:08:59': 818.0,
                                 '24/09/2023 05:10:59': 136.0,
                                 '24/09/2023 05:13:00': 35.0, '24/09/2023 05:15:00': 414.0,
                                 '24/09/2023 05:17:00': 677.0,
                                 '24/09/2023 05:19:00': 483.0, '24/09/2023 05:21:00': 418.0,
                                 '24/09/2023 05:23:00': 146.0,
                                 '24/09/2023 05:24:59': 945.0, '24/09/2023 05:26:59': 446.0,
                                 '24/09/2023 05:29:00': 513.0,
                                 '24/09/2023 05:31:00': 852.0, '24/09/2023 05:32:59': 343.0,
                                 '24/09/2023 05:35:00': 371.0,
                                 '24/09/2023 05:36:59': 937.0, '24/09/2023 05:39:00': 646.0,
                                 '24/09/2023 05:40:59': 397.0,
                                 '24/09/2023 05:43:00': 591.0, '24/09/2023 05:44:59': 924.0,
                                 '24/09/2023 05:47:00': 938.0,
                                 '24/09/2023 05:49:00': 174.0, '24/09/2023 05:50:59': 371.0,
                                 '24/09/2023 05:53:00': 434.0,
                                 '24/09/2023 05:54:59': 512.0, '24/09/2023 05:56:59': 297.0,
                                 '24/09/2023 05:59:00': 551.0,
                                 '24/09/2023 06:00:59': 581.0, '24/09/2023 06:02:59': 353.0,
                                 '24/09/2023 06:04:59': 633.0,
                                 '24/09/2023 06:06:59': 685.0, '24/09/2023 06:09:00': 877.0,
                                 '24/09/2023 06:10:59': 22.0,
                                 '24/09/2023 06:12:59': 22.0, '24/09/2023 06:14:59': 62.0, '24/09/2023 06:16:59': 619.0,
                                 '24/09/2023 06:19:00': 396.0, '24/09/2023 06:21:00': 584.0,
                                 '24/09/2023 06:22:59': 549.0,
                                 '24/09/2023 06:24:59': 761.0, '24/09/2023 06:26:59': 310.0,
                                 '24/09/2023 06:29:00': 728.0,
                                 '24/09/2023 06:31:00': 688.0, '24/09/2023 06:32:59': 782.0,
                                 '24/09/2023 06:34:59': 10.0,
                                 '24/09/2023 06:37:00': 665.0, '24/09/2023 06:39:00': 322.0,
                                 '24/09/2023 06:40:59': 864.0,
                                 '24/09/2023 06:42:59': 597.0, '24/09/2023 06:45:00': 89.0,
                                 '24/09/2023 06:46:59': 573.0,
                                 '24/09/2023 06:49:00': 732.0, '24/09/2023 06:50:59': 288.0,
                                 '24/09/2023 06:52:59': 520.0,
                                 '24/09/2023 06:54:59': 476.0, '24/09/2023 06:56:59': 584.0,
                                 '24/09/2023 06:59:00': 837.0,
                                 '24/09/2023 07:00:59': 380.0, '24/09/2023 07:02:59': 629.0,
                                 '24/09/2023 07:05:00': 421.0,
                                 '24/09/2023 07:07:00': 638.0, '24/09/2023 07:08:59': 381.0,
                                 '24/09/2023 07:10:59': 535.0,
                                 '24/09/2023 07:13:00': 414.0, '24/09/2023 07:14:59': 984.0,
                                 '24/09/2023 07:17:00': 708.0,
                                 '24/09/2023 07:19:00': 902.0, '24/09/2023 07:20:59': 117.0,
                                 '24/09/2023 07:23:00': 833.0,
                                 '24/09/2023 07:24:59': 67.0, '24/09/2023 07:26:59': 325.0, '24/09/2023 07:28:59': 24.0,
                                 '24/09/2023 07:30:59': 152.0, '24/09/2023 07:32:59': 173.0,
                                 '24/09/2023 07:35:00': 31.0,
                                 '24/09/2023 07:37:00': 454.0, '24/09/2023 07:39:00': 111.0,
                                 '24/09/2023 07:40:59': 140.0,
                                 '24/09/2023 07:42:59': 422.0, '24/09/2023 07:44:59': 247.0,
                                 '24/09/2023 07:46:59': 331.0,
                                 '24/09/2023 07:49:00': 797.0, '24/09/2023 07:50:59': 955.0,
                                 '24/09/2023 07:53:00': 375.0,
                                 '24/09/2023 07:54:59': 347.0, '24/09/2023 07:57:00': 949.0,
                                 '24/09/2023 07:58:59': 33.0,
                                 '24/09/2023 08:01:00': 698.0, '24/09/2023 08:02:59': 300.0,
                                 '24/09/2023 08:04:59': 807.0,
                                 '24/09/2023 08:07:00': 7.0, '24/09/2023 08:09:00': 144.0, '24/09/2023 08:11:00': 763.0,
                                 '24/09/2023 08:12:59': 838.0, '24/09/2023 08:15:00': 444.0,
                                 '24/09/2023 08:16:59': 771.0,
                                 '24/09/2023 08:18:59': 796.0, '24/09/2023 08:20:59': 13.0,
                                 '24/09/2023 08:22:59': 421.0,
                                 '24/09/2023 08:24:59': 614.0, '24/09/2023 08:26:59': 933.0,
                                 '24/09/2023 08:29:00': 632.0,
                                 '24/09/2023 08:30:59': 428.0, '24/09/2023 08:32:59': 963.0,
                                 '24/09/2023 08:35:00': 728.0,
                                 '24/09/2023 08:37:00': 778.0, '24/09/2023 08:39:00': 596.0,
                                 '24/09/2023 08:40:59': 40.0,
                                 '24/09/2023 08:43:00': 870.0, '24/09/2023 08:45:00': 526.0,
                                 '24/09/2023 08:46:59': 344.0,
                                 '24/09/2023 08:49:00': 91.0, '24/09/2023 08:51:00': 803.0,
                                 '24/09/2023 08:52:59': 968.0,
                                 '24/09/2023 08:55:00': 207.0, '24/09/2023 08:57:00': 588.0,
                                 '24/09/2023 08:59:00': 393.0,
                                 '24/09/2023 09:00:59': 228.0, '24/09/2023 09:02:59': 109.0,
                                 '24/09/2023 09:04:59': 249.0,
                                 '24/09/2023 09:06:59': 365.0, '24/09/2023 09:08:59': 733.0,
                                 '24/09/2023 09:11:00': 771.0,
                                 '24/09/2023 09:12:59': 172.0, '24/09/2023 09:14:59': 812.0,
                                 '24/09/2023 09:16:59': 672.0,
                                 '24/09/2023 09:19:00': 27.0, '24/09/2023 09:21:00': 34.0, '24/09/2023 09:23:00': 823.0,
                                 '24/09/2023 09:24:59': 711.0, '24/09/2023 09:26:59': 594.0,
                                 '24/09/2023 09:29:00': 864.0,
                                 '24/09/2023 09:30:59': 841.0, '24/09/2023 09:32:59': 837.0,
                                 '24/09/2023 09:35:00': 678.0,
                                 '24/09/2023 09:36:59': 52.0, '24/09/2023 09:38:59': 124.0,
                                 '24/09/2023 09:41:00': 875.0,
                                 '24/09/2023 09:42:59': 723.0, '24/09/2023 09:44:59': 719.0,
                                 '24/09/2023 09:47:00': 641.0,
                                 '24/09/2023 09:48:59': 209.0, '24/09/2023 09:50:59': 745.0,
                                 '24/09/2023 09:52:59': 884.0,
                                 '24/09/2023 09:54:59': 879.0, '24/09/2023 09:56:59': 272.0,
                                 '24/09/2023 09:59:00': 63.0,
                                 '24/09/2023 10:01:00': 71.0, '24/09/2023 10:02:59': 75.0, '24/09/2023 10:04:59': 812.0,
                                 '24/09/2023 10:07:00': 974.0, '24/09/2023 10:09:00': 196.0,
                                 '24/09/2023 10:11:00': 542.0,
                                 '24/09/2023 10:12:59': 993.0, '24/09/2023 10:15:00': 149.0,
                                 '24/09/2023 10:17:00': 340.0,
                                 '24/09/2023 10:19:00': 252.0, '24/09/2023 10:20:59': 840.0,
                                 '24/09/2023 10:23:00': 725.0,
                                 '24/09/2023 10:24:59': 438.0, '24/09/2023 10:26:59': 378.0,
                                 '24/09/2023 10:29:00': 982.0,
                                 '24/09/2023 10:31:00': 592.0, '24/09/2023 10:33:00': 110.0,
                                 '24/09/2023 10:35:00': 46.0,
                                 '24/09/2023 10:36:59': 637.0, '24/09/2023 10:39:00': 306.0,
                                 '24/09/2023 10:40:59': 451.0,
                                 '24/09/2023 10:43:00': 466.0, '24/09/2023 10:44:59': 364.0,
                                 '24/09/2023 10:46:59': 493.0,
                                 '24/09/2023 10:49:00': 58.0, '24/09/2023 10:50:59': 757.0,
                                 '24/09/2023 10:52:59': 231.0,
                                 '24/09/2023 10:55:00': 34.0, '24/09/2023 10:56:59': 598.0,
                                 '24/09/2023 10:59:00': 233.0,
                                 '24/09/2023 11:00:59': 220.0, '24/09/2023 11:02:59': 350.0,
                                 '24/09/2023 11:04:59': 671.0,
                                 '24/09/2023 11:06:59': 219.0, '24/09/2023 11:09:00': 773.0,
                                 '24/09/2023 11:10:59': 699.0,
                                 '24/09/2023 11:13:00': 647.0, '24/09/2023 11:15:00': 671.0,
                                 '24/09/2023 11:17:00': 253.0,
                                 '24/09/2023 11:19:00': 132.0, '24/09/2023 11:20:59': 900.0,
                                 '24/09/2023 11:22:59': 768.0,
                                 '24/09/2023 11:25:00': 507.0, '24/09/2023 11:26:59': 934.0,
                                 '24/09/2023 11:28:59': 525.0,
                                 '24/09/2023 11:31:00': 749.0, '24/09/2023 11:32:59': 881.0,
                                 '24/09/2023 11:34:59': 197.0,
                                 '24/09/2023 11:37:00': 893.0, '24/09/2023 11:38:59': 446.0,
                                 '24/09/2023 11:41:00': 451.0,
                                 '24/09/2023 11:42:59': 730.0, '24/09/2023 11:45:00': 567.0,
                                 '24/09/2023 11:46:59': 858.0,
                                 '24/09/2023 11:49:00': 241.0, '24/09/2023 11:50:59': 331.0,
                                 '24/09/2023 11:52:59': 598.0,
                                 '24/09/2023 11:55:00': 384.0, '24/09/2023 11:56:59': 448.0,
                                 '24/09/2023 11:59:00': 991.0,
                                 '24/09/2023 12:01:00': 556.0, '24/09/2023 12:02:59': 333.0,
                                 '24/09/2023 12:05:00': 416.0,
                                 '24/09/2023 12:06:59': 287.0, '24/09/2023 12:08:59': 777.0,
                                 '24/09/2023 12:10:59': 93.0,
                                 '24/09/2023 12:12:59': 11.0, '24/09/2023 12:15:00': 509.0,
                                 '24/09/2023 12:17:00': 652.0,
                                 '24/09/2023 12:19:00': 623.0, '24/09/2023 12:21:00': 815.0,
                                 '24/09/2023 12:23:00': 940.0,
                                 '24/09/2023 12:24:59': 415.0, '24/09/2023 12:27:00': 2.0, '24/09/2023 12:29:00': 671.0,
                                 '24/09/2023 12:31:00': 89.0, '24/09/2023 12:32:59': 870.0,
                                 '24/09/2023 12:34:59': 667.0,
                                 '24/09/2023 12:36:59': 881.0, '24/09/2023 12:39:00': 253.0,
                                 '24/09/2023 12:40:59': 817.0,
                                 '24/09/2023 12:43:00': 277.0, '24/09/2023 12:45:00': 221.0,
                                 '24/09/2023 12:46:59': 882.0,
                                 '24/09/2023 12:49:00': 331.0, '24/09/2023 12:50:59': 352.0,
                                 '24/09/2023 12:52:59': 709.0,
                                 '24/09/2023 12:55:00': 61.0, '24/09/2023 12:57:00': 331.0,
                                 '24/09/2023 12:59:00': 717.0,
                                 '24/09/2023 13:00:59': 525.0, '24/09/2023 13:03:00': 619.0,
                                 '24/09/2023 13:05:00': 380.0,
                                 '24/09/2023 13:06:59': 110.0, '24/09/2023 13:09:00': 620.0,
                                 '24/09/2023 13:10:59': 734.0,
                                 '24/09/2023 13:13:00': 736.0, '24/09/2023 13:15:00': 846.0,
                                 '24/09/2023 13:16:59': 124.0,
                                 '24/09/2023 13:19:00': 789.0, '24/09/2023 13:20:59': 213.0,
                                 '24/09/2023 13:22:59': 578.0,
                                 '24/09/2023 13:25:00': 208.0, '24/09/2023 13:27:00': 387.0,
                                 '24/09/2023 13:28:59': 987.0,
                                 '24/09/2023 13:30:59': 535.0, '24/09/2023 13:32:59': 579.0,
                                 '24/09/2023 13:35:00': 278.0,
                                 '24/09/2023 13:36:59': 871.0, '24/09/2023 13:38:59': 947.0,
                                 '24/09/2023 13:40:59': 970.0,
                                 '24/09/2023 13:43:00': 293.0, '24/09/2023 13:44:59': 618.0,
                                 '24/09/2023 13:47:00': 818.0,
                                 '24/09/2023 13:48:59': 833.0, '24/09/2023 13:50:59': 612.0,
                                 '24/09/2023 13:52:59': 970.0,
                                 '24/09/2023 13:54:59': 351.0, '24/09/2023 13:57:00': 306.0,
                                 '24/09/2023 13:59:00': 135.0,
                                 '24/09/2023 14:01:00': 919.0, '24/09/2023 14:02:59': 640.0,
                                 '24/09/2023 14:04:59': 784.0,
                                 '24/09/2023 14:06:59': 685.0, '24/09/2023 14:09:00': 789.0,
                                 '24/09/2023 14:10:59': 603.0,
                                 '24/09/2023 14:13:00': 806.0, '24/09/2023 14:14:59': 719.0,
                                 '24/09/2023 14:16:59': 922.0,
                                 '24/09/2023 14:19:00': 621.0, '24/09/2023 14:20:59': 77.0,
                                 '24/09/2023 14:22:59': 246.0,
                                 '24/09/2023 14:25:00': 282.0, '24/09/2023 14:26:59': 874.0,
                                 '24/09/2023 14:29:00': 732.0,
                                 '24/09/2023 14:30:59': 354.0, '24/09/2023 14:32:59': 949.0,
                                 '24/09/2023 14:34:59': 896.0,
                                 '24/09/2023 14:37:00': 311.0, '24/09/2023 14:39:00': 288.0,
                                 '24/09/2023 14:40:59': 830.0,
                                 '24/09/2023 14:42:59': 282.0, '24/09/2023 14:44:59': 628.0,
                                 '24/09/2023 14:46:59': 215.0,
                                 '24/09/2023 14:49:00': 979.0, '24/09/2023 14:50:59': 992.0,
                                 '24/09/2023 14:52:59': 936.0,
                                 '24/09/2023 14:54:59': 111.0, '24/09/2023 14:56:59': 465.0,
                                 '24/09/2023 14:59:00': 930.0,
                                 '24/09/2023 15:01:00': 239.0, '24/09/2023 15:02:59': 970.0,
                                 '24/09/2023 15:05:00': 613.0,
                                 '24/09/2023 15:06:59': 938.0, '24/09/2023 15:09:00': 219.0,
                                 '24/09/2023 15:11:00': 177.0,
                                 '24/09/2023 15:12:59': 773.0, '24/09/2023 15:14:59': 668.0,
                                 '24/09/2023 15:16:59': 330.0,
                                 '24/09/2023 15:18:59': 699.0, '24/09/2023 15:21:00': 296.0,
                                 '24/09/2023 15:23:00': 243.0,
                                 '24/09/2023 15:24:59': 896.0, '24/09/2023 15:27:00': 976.0,
                                 '24/09/2023 15:29:00': 665.0,
                                 '24/09/2023 15:31:00': 627.0, '24/09/2023 15:32:59': 364.0,
                                 '24/09/2023 15:35:00': 879.0,
                                 '24/09/2023 15:37:00': 16.0, '24/09/2023 15:39:00': 953.0, '24/09/2023 15:40:59': 45.0,
                                 '24/09/2023 15:42:59': 601.0, '24/09/2023 15:44:59': 543.0,
                                 '24/09/2023 15:47:00': 376.0,
                                 '24/09/2023 15:48:59': 340.0, '24/09/2023 15:50:59': 864.0,
                                 '24/09/2023 15:53:00': 751.0,
                                 '24/09/2023 15:54:59': 729.0, '24/09/2023 15:57:00': 8.0, '24/09/2023 15:59:00': 573.0,
                                 '24/09/2023 16:00:59': 497.0, '24/09/2023 16:02:59': 119.0,
                                 '24/09/2023 16:04:59': 704.0,
                                 '24/09/2023 16:07:00': 96.0, '24/09/2023 16:09:00': 872.0,
                                 '24/09/2023 16:10:59': 449.0,
                                 '24/09/2023 16:12:59': 1000.0, '24/09/2023 16:14:59': 157.0,
                                 '24/09/2023 16:16:59': 614.0,
                                 '24/09/2023 16:19:00': 464.0, '24/09/2023 16:20:59': 107.0,
                                 '24/09/2023 16:22:59': 589.0,
                                 '24/09/2023 16:24:59': 57.0, '24/09/2023 16:26:59': 307.0,
                                 '24/09/2023 16:29:00': 672.0,
                                 '24/09/2023 16:30:59': 626.0, '24/09/2023 16:32:59': 221.0,
                                 '24/09/2023 16:34:59': 940.0,
                                 '24/09/2023 16:36:59': 142.0, '24/09/2023 16:39:00': 832.0,
                                 '24/09/2023 16:40:59': 541.0,
                                 '24/09/2023 16:43:00': 301.0, '24/09/2023 16:45:00': 448.0,
                                 '24/09/2023 16:46:59': 176.0,
                                 '24/09/2023 16:49:00': 507.0, '24/09/2023 16:50:59': 210.0,
                                 '24/09/2023 16:52:59': 739.0,
                                 '24/09/2023 16:54:59': 328.0, '24/09/2023 16:56:59': 975.0,
                                 '24/09/2023 16:59:00': 118.0,
                                 '24/09/2023 17:01:00': 611.0, '24/09/2023 17:03:00': 149.0,
                                 '24/09/2023 17:04:59': 284.0,
                                 '24/09/2023 17:07:00': 449.0, '24/09/2023 17:09:00': 874.0,
                                 '24/09/2023 17:10:59': 288.0,
                                 '24/09/2023 17:12:59': 737.0, '24/09/2023 17:15:00': 328.0,
                                 '24/09/2023 17:17:00': 564.0,
                                 '24/09/2023 17:19:18': 431.0, '24/09/2023 17:20:59': 898.0,
                                 '24/09/2023 17:23:00': 229.0,
                                 '24/09/2023 17:25:00': 833.0, '24/09/2023 17:27:00': 161.0,
                                 '24/09/2023 17:28:59': 594.0,
                                 '24/09/2023 17:30:59': 30.0, '24/09/2023 17:32:59': 933.0,
                                 '24/09/2023 17:35:00': 670.0,
                                 '24/09/2023 17:36:59': 349.0, '24/09/2023 17:38:59': 996.0,
                                 '24/09/2023 17:41:00': 613.0,
                                 '24/09/2023 17:42:59': 12.0, '24/09/2023 17:44:59': 229.0,
                                 '24/09/2023 17:46:59': 387.0,
                                 '24/09/2023 17:49:00': 976.0, '24/09/2023 17:50:59': 697.0,
                                 '24/09/2023 17:53:00': 408.0,
                                 '24/09/2023 17:54:59': 608.0, '24/09/2023 17:56:59': 304.0,
                                 '24/09/2023 17:59:00': 857.0,
                                 '24/09/2023 18:00:59': 751.0, '24/09/2023 18:03:00': 107.0,
                                 '24/09/2023 18:04:59': 600.0,
                                 '24/09/2023 18:06:59': 961.0, '24/09/2023 18:09:00': 443.0,
                                 '24/09/2023 18:11:00': 994.0,
                                 '24/09/2023 18:12:59': 38.0, '24/09/2023 18:14:59': 97.0, '24/09/2023 18:17:00': 80.0,
                                 '24/09/2023 18:19:00': 686.0, '24/09/2023 18:20:59': 215.0,
                                 '24/09/2023 18:22:59': 894.0,
                                 '24/09/2023 18:24:59': 583.0, '24/09/2023 18:26:59': 156.0,
                                 '24/09/2023 18:29:00': 86.0,
                                 '24/09/2023 18:30:59': 244.0, '24/09/2023 18:33:00': 92.0,
                                 '24/09/2023 18:34:59': 836.0,
                                 '24/09/2023 18:36:59': 796.0, '24/09/2023 18:39:00': 970.0,
                                 '24/09/2023 18:41:00': 892.0,
                                 '24/09/2023 18:42:59': 725.0, '24/09/2023 18:44:59': 645.0,
                                 '24/09/2023 18:47:00': 166.0,
                                 '24/09/2023 18:49:00': 821.0, '24/09/2023 18:51:00': 719.0,
                                 '24/09/2023 18:52:59': 280.0,
                                 '24/09/2023 18:54:59': 978.0, '24/09/2023 18:56:59': 317.0,
                                 '24/09/2023 18:59:00': 222.0,
                                 '24/09/2023 19:00:59': 977.0, '24/09/2023 19:02:59': 447.0,
                                 '24/09/2023 19:04:59': 709.0,
                                 '24/09/2023 19:06:59': 142.0, '24/09/2023 19:09:00': 364.0,
                                 '24/09/2023 19:11:00': 174.0,
                                 '24/09/2023 19:13:00': 99.0, '24/09/2023 19:14:59': 578.0,
                                 '24/09/2023 19:16:59': 245.0,
                                 '24/09/2023 19:19:00': 807.0, '24/09/2023 19:21:00': 394.0,
                                 '24/09/2023 19:23:00': 780.0,
                                 '24/09/2023 19:25:00': 551.0, '24/09/2023 19:26:59': 343.0,
                                 '24/09/2023 19:29:00': 75.0,
                                 '24/09/2023 19:31:00': 416.0, '24/09/2023 19:32:59': 280.0,
                                 '24/09/2023 19:34:59': 390.0,
                                 '24/09/2023 19:37:00': 311.0, '24/09/2023 19:39:00': 954.0,
                                 '24/09/2023 19:41:00': 487.0,
                                 '24/09/2023 19:42:59': 18.0, '24/09/2023 19:44:59': 170.0,
                                 '24/09/2023 19:47:00': 336.0,
                                 '24/09/2023 19:49:00': 776.0, '24/09/2023 19:51:00': 470.0,
                                 '24/09/2023 19:52:59': 609.0,
                                 '24/09/2023 19:54:59': 927.0, '24/09/2023 19:56:59': 606.0,
                                 '24/09/2023 19:59:00': 391.0,
                                 '24/09/2023 20:00:59': 316.0, '24/09/2023 20:03:00': 403.0,
                                 '24/09/2023 20:05:00': 178.0,
                                 '24/09/2023 20:06:59': 742.0, '24/09/2023 20:09:00': 558.0,
                                 '24/09/2023 20:10:59': 318.0,
                                 '24/09/2023 20:12:59': 752.0, '24/09/2023 20:14:59': 544.0,
                                 '24/09/2023 20:17:00': 763.0,
                                 '24/09/2023 20:19:00': 985.0, '24/09/2023 20:21:00': 563.0,
                                 '24/09/2023 20:22:59': 496.0,
                                 '24/09/2023 20:24:59': 586.0, '24/09/2023 20:27:00': 39.0,
                                 '24/09/2023 20:28:59': 146.0,
                                 '24/09/2023 20:31:00': 612.0, '24/09/2023 20:32:59': 885.0,
                                 '24/09/2023 20:35:00': 20.0,
                                 '24/09/2023 20:36:59': 720.0, '24/09/2023 20:39:00': 54.0, '24/09/2023 20:40:59': 13.0,
                                 '24/09/2023 20:43:00': 564.0, '24/09/2023 20:44:59': 164.0,
                                 '24/09/2023 20:46:59': 364.0,
                                 '24/09/2023 20:49:00': 870.0, '24/09/2023 20:51:00': 408.0,
                                 '24/09/2023 20:53:00': 369.0,
                                 '24/09/2023 20:55:00': 118.0, '24/09/2023 20:57:00': 458.0,
                                 '24/09/2023 20:59:00': 276.0,
                                 '24/09/2023 21:00:59': 122.0, '24/09/2023 21:02:59': 45.0,
                                 '24/09/2023 21:05:00': 644.0,
                                 '24/09/2023 21:07:00': 31.0, '24/09/2023 21:09:00': 182.0,
                                 '24/09/2023 21:10:59': 555.0,
                                 '24/09/2023 21:13:00': 887.0, '24/09/2023 21:14:59': 536.0,
                                 '24/09/2023 21:16:59': 591.0,
                                 '24/09/2023 21:19:00': 129.0, '24/09/2023 21:21:00': 431.0,
                                 '24/09/2023 21:22:59': 31.0,
                                 '24/09/2023 21:24:59': 104.0, '24/09/2023 21:26:59': 85.0,
                                 '24/09/2023 21:29:00': 740.0,
                                 '24/09/2023 21:30:59': 170.0, '24/09/2023 21:32:59': 145.0,
                                 '24/09/2023 21:34:59': 852.0,
                                 '24/09/2023 21:37:00': 919.0, '24/09/2023 21:39:00': 916.0,
                                 '24/09/2023 21:41:00': 560.0,
                                 '24/09/2023 21:42:59': 284.0, '24/09/2023 21:44:59': 857.0,
                                 '24/09/2023 21:46:59': 786.0,
                                 '24/09/2023 21:49:00': 201.0, '24/09/2023 21:50:59': 544.0,
                                 '24/09/2023 21:53:00': 629.0,
                                 '24/09/2023 21:54:59': 332.0, '24/09/2023 21:57:00': 521.0,
                                 '24/09/2023 21:59:00': 347.0,
                                 '24/09/2023 22:00:59': 272.0, '24/09/2023 22:03:00': 433.0,
                                 '24/09/2023 22:04:59': 456.0,
                                 '24/09/2023 22:06:59': 686.0, '24/09/2023 22:09:00': 642.0,
                                 '24/09/2023 22:10:59': 762.0,
                                 '24/09/2023 22:12:59': 688.0, '24/09/2023 22:14:59': 955.0,
                                 '24/09/2023 22:16:59': 108.0,
                                 '24/09/2023 22:18:59': 855.0, '24/09/2023 22:20:59': 857.0,
                                 '24/09/2023 22:22:59': 685.0,
                                 '24/09/2023 22:24:59': 681.0, '24/09/2023 22:26:59': 901.0,
                                 '24/09/2023 22:29:00': 135.0,
                                 '24/09/2023 22:31:00': 448.0, '24/09/2023 22:33:00': 444.0,
                                 '24/09/2023 22:34:59': 948.0,
                                 '24/09/2023 22:36:59': 244.0, '24/09/2023 22:39:00': 678.0,
                                 '24/09/2023 22:41:00': 152.0,
                                 '24/09/2023 22:42:59': 894.0, '24/09/2023 22:45:00': 780.0,
                                 '24/09/2023 22:46:59': 458.0,
                                 '24/09/2023 22:49:00': 66.0, '24/09/2023 22:50:59': 458.0,
                                 '24/09/2023 22:52:59': 850.0,
                                 '24/09/2023 22:54:59': 834.0, '24/09/2023 22:57:00': 234.0,
                                 '24/09/2023 22:59:00': 861.0,
                                 '24/09/2023 23:01:00': 624.0, '24/09/2023 23:02:59': 16.0,
                                 '24/09/2023 23:05:00': 420.0,
                                 '24/09/2023 23:07:00': 235.0, '24/09/2023 23:09:00': 667.0,
                                 '24/09/2023 23:10:59': 76.0,
                                 '24/09/2023 23:12:59': 812.0, '24/09/2023 23:14:59': 999.0,
                                 '24/09/2023 23:17:00': 48.0,
                                 '24/09/2023 23:18:59': 580.0, '24/09/2023 23:20:59': 580.0,
                                 '24/09/2023 23:23:00': 776.0,
                                 '24/09/2023 23:24:59': 6.0, '24/09/2023 23:27:00': 150.0, '24/09/2023 23:29:00': 504.0,
                                 '24/09/2023 23:30:59': 663.0, '24/09/2023 23:32:59': 94.0,
                                 '24/09/2023 23:34:59': 485.0,
                                 '24/09/2023 23:37:00': 333.0, '24/09/2023 23:39:00': 483.0,
                                 '24/09/2023 23:40:59': 924.0,
                                 '24/09/2023 23:42:59': 62.0, '24/09/2023 23:44:59': 270.0,
                                 '24/09/2023 23:47:00': 461.0,
                                 '24/09/2023 23:49:00': 413.0, '24/09/2023 23:50:59': 527.0,
                                 '24/09/2023 23:53:00': 432.0,
                                 '24/09/2023 23:55:00': 82.0, '24/09/2023 23:57:00': 301.0,
                                 '24/09/2023 23:59:00': 443.0}}}  # return the df in json format
