import { HttpClient } from '@angular/common/http';
import { Component, Input, ViewChild } from '@angular/core';
import * as echarts from 'echarts';
@Component({
  selector: 'app-chart-display',
  templateUrl: './chart-display.component.html',
  styleUrls: ['./chart-display.component.scss']
})
export class ChartDisplayComponent {

  @Input() widgetInfo: any;
  @Input() base_proxy: any;

  @ViewChild('ehartsTemplate') ehartsTemplate: any;

  public chartInstance: any;
  public chartOption: any;

  get _chartConfig() {
    return this.widgetInfo?.cData?.chartOptions;
  }
  constructor(private http: HttpClient) { }

  ngAfterViewInit() {
    setTimeout(() => {
      if (this.widgetInfo) {
        this.setChartOptions();
      }
    }, 2000);
  }

  setChartOptions() {
    if (!this.ehartsTemplate) { return; }
    this.chartInstance = echarts.init(this.ehartsTemplate.nativeElement);
    const url = this.base_proxy + 'widget/preview';
    this.http.get<any>(url).subscribe(res => {
      const chartOptions = res['option'];
      chartOptions['tooltip'] = this._chartConfig.tooltip || { show: false };
      if (this._chartConfig && this._chartConfig['dataZoom']) {
        chartOptions['dataZoom'] = [];
        if (this._chartConfig.dataZoom.insideZoom) {
          chartOptions['dataZoom'].push({ type: 'inside' });
        }
        if (this._chartConfig.dataZoom.xAxis) {
          chartOptions['dataZoom'].push({
            type: 'slider',
            [this._chartConfig.dataZoom.xAxisPos === 'bottom' ? 'bottom' : 'top']: 0,
            xAxisIndex: [0],
            filterMode: 'none',
          });
        }
        if (this._chartConfig.dataZoom.yAxis) {
          chartOptions['dataZoom'].push({
            type: 'slider',
            top: 'center',
            [this._chartConfig.dataZoom.yAxisPos === 'right' ? 'right' : 'left']: this._chartConfig.dataZoom.yAxisPos === 'right' ? 30 : 0,
            yAxisIndex: 0,
            filterMode: 'none',
          });
        }
      }
      const chartConfig = this._chartConfig;
      if (chartConfig.visualMap && chartConfig.visualMap.show && chartConfig.visualMap.type === 'piecewise') {
        chartOptions['visualMap'] = {
          top: 'center',
          right: '25',
          pieces: chartConfig.visualMap.pieces,
          outOfRange: { color: chartConfig.visualMap.outOfRangeColor ? chartConfig.visualMap.outOfRangeColor : '#000000' },
        };
      } else if (chartConfig.visualMap && chartConfig.visualMap.show && ['', null, undefined, 'continuous'].indexOf(chartConfig.visualMap.continuous) > -1 && chartOptions.series && chartOptions.series.length) {
        const dataMin = 0;
        const dataMax = 1500;
        chartOptions['visualMap'] = {
          top: 'center',
          right: '25',
          calculable: true,
          title: ['High', 'Low'],
          min: [null, undefined, ''].indexOf(chartConfig.visualMap.min) === -1 ? chartConfig.visualMap.min : Math.floor(dataMin || 0),
          max: [null, undefined, ''].indexOf(chartConfig.visualMap.max) === -1 ? chartConfig.visualMap.max : Math.ceil(dataMax || 200),
          inRange: {
            color: chartConfig.visualMap.inRangeColors && chartConfig.visualMap.inRangeColors.length ? chartConfig.visualMap.inRangeColors : ['#313695', '#4575b4', '#74add1', '#abd9e9', '#e0f3f8', '#ffffbf', '#fee090', '#fdae61', '#f46d43', '#d73027', '#a50026'],
          },
        };
      } else {
        delete chartOptions['visualMap'];
      }
      this.chartInstance.setOption(chartOptions);
    });
  } catch(error: any) {
    console.log(error)
  }
}
