import logging

from fastapi import APIRouter

from scripts.core.constants.api import APIEndpoints
from scripts.core.handlers.default import DefaultHandler

router = APIRouter(prefix="/report")
handler = DefaultHandler


@router.post(APIEndpoints.generate)
def generate_report():
    try:
        return handler.generate_report()
    except Exception as e:
        logging.exception(e)
