import pathlib

from pydantic import Field, BaseSettings

PROJECT_NAME = "candle"


class _Service(BaseSettings):
    MODULE_NAME: str = Field(default="candle")
    HOST: str = Field(default="0.0.0.0", env="service_host")
    PORT: int = Field(default=9090, env="port")
    BUILD_DIR: str = Field(default="scripts/templates")
    PLUGIN_NAME: str = Field(default="candle")
    PROXY: str = Field(default="/hack-repl")
    BACKEND_DIR: str = Field(default=".")


class _BasePathConf(BaseSettings):
    BASE_PATH: str = "/code/data"


class _PathToDir(BaseSettings):
    ASSETS: str = Field(default=f"{_Service().BUILD_DIR}/assets")
    BASE_PATH: pathlib.Path = pathlib.Path(_BasePathConf().BASE_PATH)
    MODULE_PATH: pathlib.Path = BASE_PATH / _Service().MODULE_NAME
    DATA: pathlib.Path = MODULE_PATH / "data"


Service = _Service()
PathToDir = _PathToDir()
