# Assignment 2




## Task 1: Working with Mongo - Advanced


## Areas covered:
- Timeseries Operation
- Working with NoSQL
- Working with Pandas

## Description:
You are given with a dataset of weather in the form of a JSON file. The end goal of the project is to create an API interface that will provide the following: 

1.  Get the user who has the highest trip duration.
2. Get the user who has used the service the most.
3. Generate Excel Report based on `bike id`, `station name` and `start date`

Sample Document:
```json
{
  "tripduration": 889,
  "start station id": 268,
  "start station name": "Howard St & Centre St",
  "end station id": 3002,
  "end station name": "South End Ave & Liberty St",
  "bikeid": 22794,
  "usertype": "Subscriber",
  "birth year": 1961,
  "start station location": {
    "type": "Point",
    "coordinates": [
      -73.99973337,
      40.71910537
    ]
  },
  "end station location": {
    "type": "Point",
    "coordinates": [
      -74.015756,
      40.711512
    ]
  },
  "start time": {
    "$date": "2016-01-01T00:01:06.000Z"
  },
  "stop time": {
    "$date": "2016-01-01T00:15:56.000Z"
  }
}
```

Bonus Points: Use Mongo Aggregate framework

### Tools to use: 
1. Pycharm / VSCode
2. Robo3T / Studio3T / MongoDB Compass
3. PyMongo


### Reference:
https://www.mongodb.com/docs/manual/tutorial/query-documents/
https://www.mongodb.com/docs/manual/reference/operator/aggregation-pipeline/
https://pandas.pydata.org/docs/reference/api/pandas.DataFrame.to_excel.html
https://fastapi.tiangolo.com/advanced/custom-response/#fileresponse
https://pymongo.readthedocs.io/en/stable/
