import datetime

import bcrypt
from fastapi.security import OAuth2PasswordBearer
from passlib.context import CryptContext
from pymongo import MongoClient

from scripts.constants.db_constants import DatabaseConstants
from scripts.utils.mongo_sync import MongoCollectionBaseClass

obj_mongo = MongoCollectionBaseClass(mongo_client=MongoClient(), database="userDB",
                                     collection=DatabaseConstants.collection_user_details)
project_id = "1256"
while True:
    name = input("Enter the name")
    email = input("Enter email")
    password = input("enter password")
    pwd_context = CryptContext(schemes=["bcrypt"], deprecated="auto")
    hashed_password = pwd_context.hash(password)
    is_alive = True
    user_role = "super admin"
    # Create a Python datetime object
    dt = datetime.datetime.now()
    created_at = datetime.datetime.now()
    updated_at = datetime.datetime.now()
    obj_mongo.insert_one({"project_id": project_id, "name": name, "email": email, "password": hashed_password,
                          "user_role": user_role,
                          "is_alive": is_alive, "created_at": created_at,
                          "updated_at": updated_at})
    break
