import functools

from paho.mqtt.client import Client

from scripts.core.handlers.connect_topic import on_connect
from scripts.core.handlers.message_read import on_message_handler
from scripts.logging.loggers import logger


def connecting_mqtt(mqtt_host, port, request_no):
    try:
        # creating the paho client for mqtt
        client = Client()
        client.connect(mqtt_host, int(port), int(request_no))
        client.on_connect = on_connect
        client.on_message = functools.partial(on_message_handler)
        client.loop_forever()
    except Exception as e:
        logger.error("Exception occurred while connecting to mqtt: ", e)
