import configparser


config = configparser.RawConfigParser()
config.read("conf/application.conf")


# path
base_path = config.get("path", 'base_path')
sub_path = config.get("path", "sub_path")
log_path = config.get("path", "log_path")

# log
formatter_time = config.get("log", "formatter_time")
formatter_level = config.get("log", "formatter_level")

# mqtt
topic_name = config.get("mqtt", "topic")
mqtt_host = config.get("mqtt", "mqtt_host")
port = config.get("mqtt", "port")
request_no = config.get("mqtt", "requests")

# db connection
client_connect = config.get("connection", "mongodb")


# uvicorn
uvicorn_host = config.get("uvicorn", "uvicorn_host")
uvicorn_port = config.get("uvicorn", "uvicorn_port")

# redis
redis_host = config.get("redis_db", "redis_host")
db_queue_doctor = config.get("redis_db", "db_queue_doctor")

# encode
utf_encode = config.get("encode", "encode")
