import uvicorn
from fastapi import FastAPI

from scripts.config.applications_config import uvicorn_host, uvicorn_port
from scripts.logging.loggers import logger
from scripts.services.receiver_app_run import receiver_mqtt

app = FastAPI()
app.include_router(receiver_mqtt)

# starting the application
if __name__ == "__main__":
    try:
        print("redis MQTT task")
        uvicorn.run(app, host=uvicorn_host, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)
