from fastapi import APIRouter

from scripts.constants.api_route_config import index_route
from scripts.config.applications_config import mqtt_host, port, request_no
from scripts.core.handlers.connect_mqtt_receive import connecting_mqtt
from scripts.logging.loggers import logger

# This is the Subscriber

receiver_mqtt = APIRouter()


# subscribing to the doctor topics and getting the messages
@receiver_mqtt.get(index_route)
def receiver():
    try:
        connecting_mqtt(mqtt_host, port, request_no)
    except Exception as e:
        logger.error("Exception occurred while connecting to mqtt", e)
