from paho.mqtt.client import Client

from scripts.core.handlers.check_patient import patient_data_check
from scripts.core.handlers.generating_patient_data import generate_patients
from scripts.logging.loggers import logger


def generate_patients_publish(mqtt_host, port, conn_queue, conn_patient, doctors_counter, patient_data_val):
    try:
        client = Client()

        # creating the paho client to listen to the port
        client.connect(mqtt_host, int(port))

        # generating the patients
        dict_data = generate_patients(patient_data_val)

        # checking if the next doctor queue exists
        if not conn_queue.exists('next_doc'):
            conn_queue.set('next_doc', 0)

        # checking the patient datas in the db for the queue
        patient_data_check(conn_queue, conn_patient, client, dict_data, doctors_counter)
    except Exception as e:
        logger.error("Exception occurred while generating and publishing: ", e)
