from scripts.logging.loggers import logger


def set_no_doctors(conn_queue, no_doctors):
    try:
        # entering the number of doctors in to the redis db
        conn_queue.set("Doctors", no_doctors)

        # creating the queue for doctors if it doesn't exist
        for doctors in range(0, no_doctors):
            if not conn_queue.exists(f'doctor{doctors}'):
                conn_queue.set(f'doctor{doctors}', '')
            else:
                continue
        return no_doctors
    except Exception as e:
        logger.error("Exception occurred while adding doctors: ", e)
