from fastapi import APIRouter

from scripts.constants import api_path_config
from scripts.config.applications_config import mqtt_host, port
from scripts.core.engine.models.patient_model import Patient
from scripts.core.handlers.deleting_doctor_queue import delete_queue
from scripts.core.handlers.doctors_number import set_no_doctors
from scripts.core.handlers.generate_publish import generate_patients_publish
from scripts.database.redis_db import conn_queue, conn_patient

# count the number of doctors for the day
doctors_counter = 0
assign_doctor = APIRouter()


# generating the doctors for the day
@assign_doctor.get(api_path_config.doctors_count)
def get_doctors(no_doctors: int):
    try:
        global doctors_counter
        doctors_counter += set_no_doctors(conn_queue, no_doctors)
    except Exception as e:
        print(e)
    else:
        return "Doctors queue created"


# closing the doctors for the day
@assign_doctor.post(api_path_config.close_day)
def get_doctors():
    try:
        global doctors_counter
        delete_queue(doctors_counter, conn_queue)
    except Exception as e:
        print(e)
    else:
        return "Doctors deleted"


# getting the producing the patient details for the consumer
@assign_doctor.post(api_path_config.patient_details)
def patient_data(body: Patient):
    try:
        global doctors_counter

        # getting the patient details from the user
        patient_data_val = Patient(patient_id=body.patient_id, description=body.description,
                                   age=body.age, name=body.name)
        generate_patients_publish(mqtt_host, port, conn_queue, conn_patient, doctors_counter, patient_data_val)
    except Exception as e:
        print(e)
    else:
        return "Doctor assigned patient"
