from scripts.core.handlers.next_doc_assign import assign_new_doctor
from scripts.logging.loggers import logger


# creating a round-robin for the new patient for the doctor
def set_patient_queue(conn_queue, conn_patient, client, dict_data, next_doc, doctors_counter):
    try:
        # check if the next doctor is not the last index
        if int(next_doc) != doctors_counter:
            # assign the doctor
            assign_new_doctor(conn_queue, conn_patient, client, dict_data, next_doc)
            conn_queue.set('next_doc', next_doc + 1)

        else:
            conn_queue.set('next_doc', 0)

            # setting the doctors queue empty
            for doctors in range(0, doctors_counter):
                conn_queue.set(f'doctor{doctors}', '')

            # assigning new doctor to the patient
            assign_new_doctor(conn_queue, conn_patient, client, dict_data, 0)
            conn_queue.set('next_doc', 1)
    except Exception as e:
        logger.error("Exception occurred while checking the queue: ", e)
