# assigning existing patients to the doctors
import time

from scripts.logging.loggers import logger


def assign_doc_exist(conn_queue, conn_patient, client, dict_data):
    try:
        # getting the doctor id from the patient db
        doctor = conn_patient.hmget(dict_data['patient_id'], 'doctor')

        avi_doc = conn_queue.get(doctor[0].decode())

        # check if the doctor queue is empty
        if avi_doc != b'':
            print("Wait for the doctor to be free...")
            time.sleep(3)
        conn_queue.set(doctor[0].decode(), '')

        patient_id = dict_data['patient_id']

        # publishing the doctor
        client.publish(doctor[0].decode(), patient_id)
    except Exception as e:
        logger.error("Exception occurred while assigning existing patient: ", e)
