# assigning the doctors to new patients
import time

from scripts.logging.loggers import logger


def assign_new_doctor(conn_queue, conn_patient, client, dict_data, next_doc):
    try:
        avi_doc = conn_queue.get(f'doctor{next_doc}')

        # check if the doctor queue is empty
        if avi_doc != b'':
            print("Wait for the doctor to be free...")
            time.sleep(3)
        conn_queue.set(f'doctor{next_doc}', '')

        # updating the patient details with doctor id
        dict_data.update({"doctor": f'doctor{next_doc}'})

        # update the db with new data
        conn_patient.hmset(dict_data['patient_id'], dict_data)

        patient_id = dict_data['patient_id']
        # publish the doctor
        client.publish(f'doctor{next_doc}', patient_id)
    except Exception as e:
        logger.error("Exception occurred while assigning new doctor: ", e)
