from scripts.core.handlers.next_doc_existing import assign_doc_exist
from scripts.core.handlers.queue_check import set_patient_queue
from scripts.logging.loggers import logger


# check if the patient exists in the redis db
def patient_data_check(conn_queue, conn_patient, client, dict_data, doctors_counter):
    try:
        # check if the patient data exists in the db
        if not conn_patient.exists(dict_data['patient_id']):

            # decoding the next doc queue
            next_doc = int(conn_queue.get('next_doc').decode())
            set_patient_queue(conn_queue, conn_patient, client, dict_data, next_doc, doctors_counter)
        else:
            assign_doc_exist(conn_queue, conn_patient, client, dict_data)
    except Exception as e:
        logger.error("Exception occurred while checking for patients: ", e)
