# reading conf file
import configparser


config = configparser.RawConfigParser()
config.read("conf/applications.conf")


# path
base_path = config.get("path", 'base_path')
sub_path = config.get("path", "sub_path")
log_path = config.get("path", "log_path")

# uvicorn
uvicorn_port = config.get("uvicorn", "uvicorn_port")

# file name
file_name_json = config.get("file", "file_name_json")
full_path_json = base_path + sub_path + file_name_json

# mqtt
topic_name = config.get("mqtt", "topic")
mqtt_host = config.get("mqtt", "mqtt_host")
port = config.get("mqtt", "port")
request_no = config.get("mqtt", "requests")

# redis
redis_host = config.get("redis_db", "redis_host")
db_queue_doctor = config.get("redis_db", "db_queue_doctor")
db_patient_detail = config.get("redis_db", "db_patient_detail")

# log
formatter_time = config.get("log", "formatter_time")
formatter_level = config.get("log", "formatter_level")
