# using mongo aggregation operations
import uvicorn

from fastapi import FastAPI
from scripts.config.applications_config import uvicorn_port
from scripts.logging.loggers import logger
from scripts.services.app_services_run import assign_doctor

app = FastAPI()
app.include_router(assign_doctor)


# starting the application
if __name__ == "__main__":
    try:
        print("Redis task")
        uvicorn.run(app, port=int(uvicorn_port))
    except Exception as e:
        logger.error("Interruption occurred: ", e)

# pip install python-multipart
