from fastapi import APIRouter, Request, UploadFile, File
from fastapi.templating import Jinja2Templates
from fastapi.responses import HTMLResponse

from scripts.constants.api_routes_config import route_index, route_submit
from scripts.core.handlers.api_read import read_data_from_api
from scripts.logging.loggers import logger

business_violate = APIRouter()
templates = Jinja2Templates("scripts/core/handlers/")


# html form access using api
@business_violate.get(route_index, response_class=HTMLResponse)
def template_render(request: Request):
    try:
        return templates.TemplateResponse("upload_file.html", {"request": request})
    except Exception as e:
        logger.error("Exception occurred while loading html: ", e)


# handling the form submit using api and aggregations
@business_violate.post(route_submit)
async def submit_file_data(file_data: UploadFile = File(...)):
    try:
        data = await file_data.read()
        read_data_from_api(data)
    except Exception as e:
        logger.error("Exception occurred while submitting: ", e)
    else:
        return {"msg": "file uploading successful..."}



