# class for mongodb operations
from scripts.config.applications_config import db_name, collection_name
from scripts.core.database.mongodb_connect import client
from scripts.core.handlers.data_insert import insert_data_db
from scripts.core.handlers.no_violations_data import db_select_no_violate
from scripts.core.handlers.result_generate import results_data
from scripts.core.handlers.violation_find import db_select_violate
from scripts.logging.loggers import logger


class MongoDbStart:
    # create mongo table
    @staticmethod
    def mongo_create():
        try:
            client_con = client
        except Exception as e:
            logger.error("Exception occurred while connecting to mongo: ", e)
        else:
            db = client_con[db_name]
            log_name = db[collection_name]
            return log_name

    # mongo data insert
    @staticmethod
    # getting input and insert into db
    def mongo_insert(db, decoded):
        try:
            insert_check = insert_data_db(db, decoded)
            if insert_check.acknowledged:
                print("Data inserted....")
            else:
                print("Something went wrong data cannot be inserted....")
        except Exception as e:
            logger.error("Exception occurred while inserting to collection: ", e)

    # mongo aggregate find businessman with most violations
    @staticmethod
    def mongo_violation(db):
        try:
            db_select_violate(db)
        except Exception as e:
            logger.error("Exception occurred while fetching violations: ", e)

    # mongo aggregate find businessman with no violations
    @staticmethod
    def mongo_no_violation(db):
        try:
            db_select_no_violate(db)
        except Exception as e:
            logger.error("Exception occurred while fetching for no violations: ", e)

    # mongo aggregate find
    @staticmethod
    def mongo_view_results(db):
        try:
            data = results_data(db)
            return data
        except Exception as e:
            logger.error("Exception occurred while fetching all: ", e)
